<!doctype html>
<html lang="en-US">
  	<head>
		{block name='head'}
			{include file='_partials/head.tpl'}
		{/block}
	</head>

	<body class="{$body_classes|classnames} {if $theme_mode_night}night-mode{/if}">

        <div class="main-wrapper">

            {block name='header'}
				{include file='_partials/header.tpl'}
			{/block}

            {if $do == "reset"}

                <!-- page header -->
                <div class="page-header bg-2">
                    <img class="floating-img d-none d-md-block" src="{$theme_uri}/static/images/headers/undraw_message_sent_1030.svg">
                    <div class="crystal c03"></div>
                    <div class="circle-2"></div>
                    <div class="circle-3"></div>
                    <div class="inner">
                        <h2>Reset Password</h2>
                        <p>Enter the email address you signed up with and we'll email you a reset link</p>
                    </div>
                </div>
                <!-- page header -->

                <!-- page content -->
                <div class="container" style="margin-top: -25px;">
                    <div class="row">
                        <div class="col-12 col-md-8 col-lg-6 col-xl-5 mauto">
                            <div class="card px-4 py-4 shadow">
                                <div class="card-body">
                                    <form class="js_ajax-forms" data-url="/reset-password">
                                        <div class="form-group">
                                            <label class="form-control-label">Email</label>
                                            <input name="email" id="email" type="text" class="form-control mb10" required autofocus>
                                            <p class="text-secondary">Enter the email address you signed up with and we'll email you a reset link.</p>
                                        </div>
                                        
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-block btn-info">
                                                <i class="far fa-envelope-open mr10"></i> Email me a link
                                            </button>
                                        </div>

                                        <!-- error -->
                                        <div class="alert alert-danger x-hidden"></div>
                                        <!-- error -->
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- page content -->

            {elseif $do == "change"}

                <!-- page header -->
                <div class="page-header bg-2">
                    <img class="floating-img d-none d-md-block" src="{$theme_uri}/static/images/headers/undraw_message_sent_1030.svg">
                    <div class="crystal c03"></div>
                    <div class="circle-2"></div>
                    <div class="circle-3"></div>
                    <div class="inner">
                        <h2>Change Password</h2>
                        <p>Create a new, strong password that you don't use for other websites</p>
                    </div>
                </div>
                <!-- page header -->

                <!-- page content -->
                <div class="container" style="margin-top: -25px;">
                    <div class="row">
                        <div class="col-12 col-md-8 col-lg-6 col-xl-5 mauto">
                            <div class="card px-4 py-4 shadow">
                                <div class="card-body">
                                    <form class="js_ajax-forms" data-url="/forget-password-confirm">
                                        <input type="hidden" name="reset_key" value="{$reset_key}"/>
                                        <div class="form-group">
                                            <label for="new">New password</label>
                                            <input name="new" id="new" type="password" class="form-control" required>
                                        </div>

                                        <div class="form-group">
                                            <label for="confirm">Confirm Password</label>
                                            <input name="confirm" id="confirm" type="password" class="form-control" required>
                                        </div>

                                        <!-- error -->
                                        <div class="alert alert-danger x-hidden" role="alert"></div>
                                        <!-- error -->

                                        <button type="submit" class="btn btn-primary btn-block">Change Password</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- page content -->

            {/if}
        </div>
	</body>

    {include file="_partials/_js_files.tpl"}
    
</html>
