{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon">
        {if $sub_view == "currency"}
            <div class="pull-right flip">
                <a href="{$base_uri}/system/currency/add" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Add New Currency
                </a>
            </div>
        {/if}

        <i class="fa fa-money-bill-alt mr10"></i>
        <strong>Currency</strong>
        {if $sub_view == "edit"} &rsaquo; <strong>{$currency.title}</strong>{/if}
        {if $sub_view == "add"} &rsaquo; <strong>Add New</strong>{/if}
    </div>

    {if $sub_view == "currency"}

        <div class="card-body">

            {if count($currencies)}
                <div class="table-responsive">
                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                <th>Title</th>
                                <th>Currency</th>
                                <th>Symbol</th>
                                <th>Exchange Rate</th>
                                <th>Active</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $currencies as $currency}
                                <tr>
                                    <td>{$currency.title}</td>
                                    <td>{$currency.iso_code}</td>
                                    <td>{$currency.symbol}</td>
                                    <td>{$currency.conversion_rate}</td>
                                    <td>
                                        {if $currency.active}
                                            <span class="label label-success">Yes</span>
                                        {else}
                                            <span class="label label-danger">No</span>
                                        {/if}    
                                    </td>
                                    <td>
                                        <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="currency" data-id="{$currency.id}">
                                            <i class="fa fa-trash-alt"></i>
                                        </button>
                                        <a data-toggle="tooltip" data-placement="top" title="Edit" href="{$base_uri}/system/currency/edit/{$currency.id}" class="btn btn-xs btn-primary">
                                            <i class="fa fa-pencil-alt"></i>
                                        </a>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    {$pager nofilter}
                </div>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>No currencies to show</strong></p>
                </div>
            {/if}
        </div>

    {elseif $sub_view == "edit"}
        <div class="card-body">
            <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/currency?do=edit">
                <input type="hidden" name="currency_id" value="{$currency.id}"/>
                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        Title
                    </label>
                    <div class="col-sm-9">
                        <input class="form-control" type="text" name="title" value="{$currency.title}" required>
                        <span class="help-block">
                            Currency title i.e US Dollars, Canadian Dollars
                        </span>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        ISO Code
                    </label>
                    <div class="col-sm-9">
                        <input class="form-control" type="text" name="iso_code" value="{$currency.iso_code}" required>
                        <span class="help-block">
                            Currency ISO Code i.e USD, GBP. List of <a target="_blank" href="https://www.iban.com/currency-codes">ISO Codes</a>.
                        </span>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        Symbol
                    </label>
                    <div class="col-sm-9">
                        <input class="form-control" type="text" name="symbol"  value="{$currency.symbol}" required>
                        <span class="help-block">
                            Currency symbol €, £, $, ¥ 
                        </span>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        Exchange Rate
                    </label>
                    <div class="col-sm-9">
                        <input class="form-control force-integer" type="text" name="conversion_rate" value="{$currency.conversion_rate}" required>
                        <span class="help-block">
                            1 USD is equivalent to the <strong>Exchange Rate</strong> this currency. Default is 1
                        </span>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        Active
                    </label>
                    <div class="col-sm-9">
                        <label class="switch" for="active">
                            <input type="checkbox" name="active" id="active" {if $currency.active == '1'}checked="checked"{/if}>
                            <span class="slider round"></span>
                        </label>
                        <span class="help-block">
                            Display this currency in checkout forms
                        </span>
                    </div>
                </div>

                <div class="form-group form-row">
                    <div class="col-sm-9 offset-sm-3">
                        <!-- success -->
                        <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                        <!-- success -->

                        <!-- error -->
                        <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                        <!-- error -->

                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>
                </div>

            </form>
        </div>
    {elseif $sub_view == "add"}
        <div class="card-body">
            <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/currency?do=add">
                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        Title
                    </label>
                    <div class="col-sm-9">
                        <input class="form-control" type="text" name="title" required>
                        <span class="help-block">
                            Currency title i.e US Dollars, Canadian Dollars
                        </span>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        ISO Code
                    </label>
                    <div class="col-sm-9">
                        <input class="form-control" type="text" name="iso_code" required>
                        <span class="help-block">
                            Currency ISO Code i.e USD, GBP. List of <a target="_blank" href="https://www.iban.com/currency-codes">ISO Codes</a>.
                        </span>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        Symbol
                    </label>
                    <div class="col-sm-9">
                        <input class="form-control" type="text" name="symbol" required>
                        <span class="help-block">
                            Currency symbol €, £, $, ¥ 
                        </span>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        Exchange Rate
                    </label>
                    <div class="col-sm-9">
                        <input class="form-control force-integer" type="text" name="conversion_rate" required>
                        <span class="help-block">
                            1 USD is equivalent to the <strong>Exchange Rate</strong> this currency. Default is 1
                        </span>
                    </div>
                </div>

                <div class="form-group form-row">
                    <div class="col-sm-9 offset-sm-3">
                        <!-- success -->
                        <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                        <!-- success -->

                        <!-- error -->
                        <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                        <!-- error -->

                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>
                </div>

            </form>
        </div>
    {/if}

</div>
{/block}