{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <!-- card-header -->
    <div class="card-header with-icon with-nav">
        <!-- panel title -->
        <div class="mb20">
            <i class="fa fa-cog mr10"></i> Settings &rsaquo; Orders & Payments
        </div> 
        <!-- panel title -->

        <!-- panel nav -->
        <ul class="nav nav-tabs">
            <li class="nav-item">
                <a class="nav-link active" href="#General" data-toggle="tab">
                    <i class="fa fa-cog fa-fw mr5"></i><strong class="pr5">General</strong>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="#PaymentRequests" data-toggle="tab">
                    <i class="fa fa-money-bill-alt fa-fw mr5"></i><strong class="pr5">Payment Requests</strong>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link"href="#writer_payments" data-toggle="tab">
                    <i class="fa fa-money-bill-alt fa-fw mr5"></i>
                    <strong class="pr5">Writer Payment</strong>
                </a>
            </li> 

            <li class="nav-item">
                <a class="nav-link"href="#editor_payments" data-toggle="tab">
                    <i class="fa fa-money-bill-alt fa-fw mr5"></i>
                    <strong class="pr5">Editor Payment</strong>
                </a>
            </li> 
        </ul>
        <!-- panel nav -->
    </div>
    <!-- card-header -->

    <!-- tabs content -->
    <div class="tab-content">
        <!-- General -->
        <div class="tab-pane active" id="General">
            <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/settings?edit=orders_settings">
                <div class="card-body">

                    <div class="heading-small mb20">Features</div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Attach Completed Files</div> 
                            <div class="form-text">Enable this to attach completed files in the customer's notification email</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="attach_completed_files"> 
                                <input type="checkbox" name="attach_completed_files" id="attach_completed_files" {if $formValues.ATTACH_COMPLETED_FILES}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Editor Account</div> 
                            <div class="form-text">Enable and Disable the editor feature</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="editor_account"> 
                                <input type="checkbox" name="editor_account" id="editor_account" {if $formValues.EDITOR_ACCOUNT_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Pay Delivered Orders</div> 
                            <div class="form-text">Include delivered orders in writers and editors payment summary</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="pay_delivered_orders"> 
                                <input type="checkbox" name="pay_delivered_orders" id="pay_delivered_orders" {if $formValues.PAY_DELIVERED_ORDERS}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Confirm Order Assign</div> 
                            <div class="form-text">Enable this to allow writers to confirm when you assign them an order</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="confirm_order_assign"> 
                                <input type="checkbox" name="confirm_order_assign" id="confirm_order_assign" {if $formValues.CONFIRM_ORDER_ASSIGN}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="divider"></div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Sub Admin Client Cost</div> 
                            <div class="form-text">Enable the sub admin to see the customer pay</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="subadmin_client_cost"> 
                                <input type="checkbox" name="subadmin_client_cost" id="subadmin_client_cost" {if $formValues.SUBADMIN_CLIENT_COST}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Sub Admin Writer Info</div> 
                            <div class="form-text">Enable the sub admin to see writer info</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="subadmin_writer_info"> 
                                <input type="checkbox" name="subadmin_writer_info" id="subadmin_writer_info" {if $formValues.SUBADMIN_WRITER_INFO}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="divider"></div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Highlight Urgent Orders</div> 
                            <div class="form-text">Enable to highlight orders with deadlines less than 10 hours</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="higlight_order_deadline"> 
                                <input type="checkbox" name="higlight_order_deadline" id="higlight_order_deadline" {if $formValues.HIGHLIGHT_ORDER_DEADLINE}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="divider"></div>

                    <div class="heading-small mb20">Preffered Writers</div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Auto-Assign Requested Writers</div> 
                            <div class="form-text">Enable this to auto-assign an order when the customer requests for a writer</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="autoassign_requested_writer"> 
                                <input type="checkbox" name="autoassign_requested_writer" id="autoassign_requested_writer" {if $formValues.AUTOASSIGN_REQUESTED_WRITER}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="divider"></div>

                    <div class="heading-small mb20">Order Manager</div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Order Manager Enabled</div> 
                            <div class="form-text">Enable this to auto-assign an order to sub admins as managers</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="order_manager_enabled"> 
                                <input type="checkbox" name="order_manager_enabled" id="order_manager_enabled" {if $formValues.ORDER_MANAGER_ENABLED}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Public Order Management</div> 
                            <div class="form-text">Allow sub admins to view all orders assigned to them and others</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="order_manager_public"> 
                                <input type="checkbox" name="order_manager_public" id="order_manager_public" {if $formValues.ORDER_MANAGER_PUBLIC}checked=""{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 form-control-label text-left">CPP Type</label>
                        <div class="col-sm-8">
                            <select class="form-control" name="ordermanager_cpp_type" data-combo="ordermanager_cpp_type">
                                <option value="percentage" {if $formValues.ORDER_MANAGER_CPP_TYPE == 'percentage'}selected=""{/if}>Percentage of the customer's CPP</option>
                                <option value="fixed" {if $formValues.ORDER_MANAGER_CPP_TYPE == 'fixed'}selected=""{/if}>Fixed amount</option>
                            </select>
                        </div>
                    </div>

                    <div id="ordermanager_cpp_type">
                        <div class="switch-combo {if $formValues.ORDER_MANAGER_CPP_TYPE != 'fixed'}x-hidden{/if}" data-combo-value="fixed">
                            <div class="form-group form-row">
                                <label class="col-sm-4 form-control-label text-left">
                                    Cost Per Page
                                </label>
                                <div class="col-sm-8">
                                    <input class="form-control force-integer" type="text" name="ordermanager_cost_per_page" value="{$formValues.ORDER_MANAGER_AMOUNT_CPP}">
                                    <span class="help-block">
                                        The amount the manager will earn per page
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="switch-combo {if $formValues.ORDER_MANAGER_CPP_TYPE != 'percentage'}x-hidden{/if}" data-combo-value="percentage">
                            <div class="form-group form-row">
                                <label class="col-sm-4 form-control-label text-left">
                                    Cost Per Page
                                </label>
                                <div class="col-sm-8">
                                    <input class="form-control force-integer" type="text" name="ordermanager_percent_per_page" value="{$formValues.ORDER_MANAGER_PERCENTAGE_CPP}">
                                    <span class="help-block">
                                        The Percentage the manager will earn from the customer's CPP
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="divider"></div>

                    <div class="heading-small mb20">Approval Time</div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Auto-approve time
                        </label>
                        <div class="col-sm-9">
                            <select class="form-control" name="autoapprove_time">
                                <option value="120" {if $formValues.ORDER_AUTOAPPROVE_TIME == '120'}selected="selected"{/if}>5 days</option>
                                <option value="168" {if $formValues.ORDER_AUTOAPPROVE_TIME == '168'}selected="selected"{/if}>7 days</option>
                                <option value="336" {if $formValues.ORDER_AUTOAPPROVE_TIME == '336'}selected="selected"{/if}>14 days</option>
                                <option value="504" {if $formValues.ORDER_AUTOAPPROVE_TIME == '504'}selected="selected"{/if}>21 days</option>
                                <option value="720" {if $formValues.ORDER_AUTOAPPROVE_TIME == '720'}selected="selected"{/if}>30 days</option>
                            </select>
                            <span class="help-block">
                                The time it will take to auto-approve an order after it is delivered to a customer
                            </span>
                        </div>
                    </div>

                    <div class="divider"></div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Order Words Per Page</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control force-integer" name="words_per_page" {if $formValues.WORDS_PER_PAGE}value="{$formValues.WORDS_PER_PAGE}"{else}value="275"{/if}>
                            <span class="help-block">The order form words per page</span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Order Autoincrement</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control force-integer" name="order_autoincrement" {if $formValues.ORDER_AUTOINCREMENT}value="{$formValues.ORDER_AUTOINCREMENT}"{else}value="2"{/if}>
                            <span class="help-block">
                                The minimum payment request an editor can request
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">New Order Status</label>
                        <div class="col-sm-9">
                            <div class="selectgroup selectgroup-inline">
                                <label class="selectgroup-item" id="new_paid_status">
                                    <input for="new_paid_status" type="radio" name="new_order_status" value="12" {if $formValues.NEW_ORDER_STATUS == "12"}checked=""{/if} class="selectgroup-input">
                                    <span class="selectgroup-button">New Paid</span>
                                </label>
                                <label class="selectgroup-item" id="new_available_status">
                                    <input for="new_available_status" type="radio" name="new_order_status" value="19" {if $formValues.NEW_ORDER_STATUS == "19"}checked=""{/if} class="selectgroup-input">
                                    <span class="selectgroup-button">Available</span>
                                </label>
                            </div>
                            <span class="help-block">The default order status of a new order</span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- General -->

        <!-- Payment Requests -->
        <div class="tab-pane" id="PaymentRequests">
            <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/settings?edit=payments_settings">
                <div class="card-body">
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Writer Payment Request Limit
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="writer_payment_request_limit" value="{$formValues.WRITER_PAYMENT_REQUEST_LIMIT}">
                            <span class="help-block">
                                The minimum payment request a writer can request
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Editor Payment Request Limit
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="editor_payment_request_limit" value="{$formValues.EDITOR_PAYMENT_REQUEST_LIMIT}">
                            <span class="help-block">
                                The minimum payment request an editor can request
                            </span>
                        </div>
                    </div>

                    <div class="divider"></div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Payment Request Dates</label>
                        <div class="col-sm-9">
                            <div class="selectgroup selectgroup-inline">
                                {foreach $payment_dates as $payment_date}
                                    <label class="selectgroup-item">
                                        <input type="checkbox" name="payment_dates[]" value="{$payment_date.day}" {if $payment_date.checked}checked=""{/if} class="selectgroup-input">
                                        <span class="selectgroup-button">{$payment_date.day}</span>
                                    </label>
                                {/foreach}
                            </div>
                            <span class="help-block">
                                Calendar dates that writers and editors can send payment requests
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <!-- Payment Requests -->

        <!-- Writer Payments -->
        <div class="tab-pane" id="writer_payments">
            <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/settings?edit=writer_payments">
                <div class="card-body">
                    <div class="heading-small mb20">Writer Pay per Page</div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">CPP Type</label>
                        <div class="col-sm-8">
                            <select class="form-control" name="writer_cpp_type" data-combo="writer_cpp_type">
                                <option value="percentage" {if $formValues.WRITER_CPP_TYPE == 'percentage'}selected=""{/if}>Percentage of the customer's CPP</option>
                                <option value="fixed" {if $formValues.WRITER_CPP_TYPE == 'fixed'}selected=""{/if}>Fixed amount</option>
                            </select>
                        </div>
                    </div>

                    <div id="writer_cpp_type">
                        <div class="switch-combo {if $formValues.WRITER_CPP_TYPE != 'fixed'}x-hidden{/if}" data-combo-value="fixed">
                            <div class="form-group form-row">
                                <label class="col-sm-4 control-label text-left">Cost Per Page</label>
                                <div class="col-sm-8">
                                    <input class="form-control force-integer" type="text" name="writer_cost_per_page" value="{$formValues.WRITER_AMOUNT_CPP}">
                                    <span class="help-block">The amount the writer will earn per page</span>
                                </div>
                            </div>
                        </div>
                        <div class="switch-combo {if $formValues.WRITER_CPP_TYPE != 'percentage'}x-hidden{/if}" data-combo-value="percentage">
                            <div class="form-group form-row">
                                <label class="col-sm-4 control-label text-left">
                                    Cost Per Page
                                </label>
                                <div class="col-sm-8">
                                    <input class="form-control force-integer" type="text" name="writer_percent_per_page" value="{$formValues.WRITER_PERCENTAGE_CPP}">
                                    <span class="help-block">
                                        The Percentage the writer will earn from the customer's CPP
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="divider"></div>
                        
                    {if $is_articlewriting_enabled}
                        <div class="heading-small mb20">Writer Pay per Word</div>
                        <div class="form-group form-row">
                            <label class="col-sm-4 control-label text-left">CPP Type</label>
                            <div class="col-sm-8">
                                <select class="form-control" name="writer_cpw_type" data-combo="writer_cpw_type">
                                    <option value="percentage" {if $formValues.WRITER_CPW_TYPE == 'percentage'}selected=""{/if}>Percentage of the customer's CPW</option>
                                    <option value="fixed" {if $formValues.WRITER_CPW_TYPE == 'fixed'}selected=""{/if}>Fixed amount</option>
                                </select>
                            </div>
                        </div>

                        <div id="writer_cpw_type">
                            <div class="switch-combo {if $formValues.WRITER_CPW_TYPE != 'fixed'}x-hidden{/if}" data-combo-value="fixed">
                                <div class="form-group form-row">
                                    <label class="col-sm-4 control-label text-left">Cost Per Word</label>
                                    <div class="col-sm-8">
                                        <input class="form-control force-integer" type="text" name="writer_cost_per_word" value="{$formValues.WRITER_AMOUNT_CPW}">
                                        <span class="help-block">The amount the writer will earn per word</span>
                                    </div>
                                </div>
                            </div>
                            <div class="switch-combo {if $formValues.WRITER_CPW_TYPE != 'percentage'}x-hidden{/if}" data-combo-value="percentage">
                                <div class="form-group form-row">
                                    <label class="col-sm-4 control-label text-left">Cost Per Word</label>
                                    <div class="col-sm-8">
                                        <input class="form-control force-integer" type="text" name="writer_percent_per_word" value="{$formValues.WRITER_PERCENTAGE_CPW}">
                                        <span class="help-block">The Percentage the writer will earn from the customer's CPW</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="divider"></div>
                    {/if}

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Writer Category</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="writer_category_cost" value="{$formValues.WRITER_W_CATEGORY_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost charged for "Writer Category"
                            </span>
                        </div>
                    </div>
                    
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Complex Assignment</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="complex_assignment_cost" value="{$formValues.WRITER_COMPLEX_ASSIGNMENT_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost charged for a complex assignment
                            </span>
                        </div>
                    </div>

                    <div class="divider"></div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Copy of Sources</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="used_sources_cost" value="{$formValues.WRITER_USED_SOURCES_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Copy of Sources" Service
                            </span>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Progressive Delivery</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="p_delivery_cost" value="{$formValues.WRITER_PROGRESSIVE_DELIVERY_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Progressive Delivery" Service
                            </span>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Writer Samples</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="writer_sample_cost" value="{$formValues.WRITER_PROVIDE_ME_SAMPLES_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Get Writer Samples" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Expert Proofreading</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="expert_proofreading_cost" value="{$formValues.WRITER_EXPERT_PROOFREADING_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Expert Proofreading" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">VIP Support</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="vip_support_cost" value="{$formValues.WRITER_VIP_SUPPORT_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "VIP Support" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Plagiarism Report</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="plagiarism_report_cost" value="{$formValues.WRITER_PLAGIARISM_REPORT_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Plagiarism Report" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Draft/Outline</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="draft_outline_cost" value="{$formValues.WRITER_DRAFT_OUTLINE_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Draft/Outline" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Preffered Writer</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="preffered_writer_cost" value="{$formValues.WRITER_PREFFERED_WRITER_COST}">
                            <span class="help-block">
                                The percentage the writer will earn when the customer requests the writer
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-8 offset-sm-4">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <!-- Writer Payments -->

        <!-- Editor Payments -->
        <div class="tab-pane" id="editor_payments">
            <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/settings?edit=editor_payments">
                <div class="card-body">
                    <div class="heading-small mb20">Editor Pay per Page</div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">CPP Type</label>
                        <div class="col-sm-8">
                            <select class="form-control" name="editor_cpp_type" data-combo="editor_cpp_type">
                                <option value="percentage" {if $formValues.EDITOR_CPP_TYPE == 'percentage'}selected=""{/if}>Percentage of the customer's CPP</option>
                                <option value="fixed" {if $formValues.EDITOR_CPP_TYPE == 'fixed'}selected=""{/if}>Fixed amount</option>
                            </select>
                        </div>
                    </div>

                    <div id="editor_cpp_type">
                        <div class="switch-combo {if $formValues.EDITOR_CPP_TYPE != 'fixed'}x-hidden{/if}" data-combo-value="fixed">
                            <div class="form-group form-row">
                                <label class="col-sm-4 control-label text-left">
                                    Cost Per Page
                                </label>
                                <div class="col-sm-8">
                                    <input class="form-control force-integer" type="text" name="editor_cost_per_page" value="{$formValues.EDITOR_AMOUNT_CPP}">
                                    <span class="help-block">
                                        The amount the editor will earn per page
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="switch-combo {if $formValues.EDITOR_CPP_TYPE != 'percentage'}x-hidden{/if}" data-combo-value="percentage">
                            <div class="form-group form-row">
                                <label class="col-sm-4 control-label text-left">
                                    Cost Per Page
                                </label>
                                <div class="col-sm-8">
                                    <input class="form-control force-integer" type="text" name="editor_percent_per_page" value="{$formValues.EDITOR_PERCENTAGE_CPP}">
                                    <span class="help-block">
                                        The Percentage the editor will earn from the customer's CPP
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    {if $is_articlewriting_enabled}
                        <div class="divider"></div>

                        <div class="heading-small mb20">Editor Pay per Word</div>
                        <div class="form-group form-row">
                            <label class="col-sm-4 control-label text-left">CPW Type</label>
                            <div class="col-sm-8">
                                <select class="form-control" name="editor_cpw_type" data-combo="editor_cpw_type">
                                    <option value="percentage" {if $formValues.EDITOR_CPW_TYPE == 'percentage'}selected=""{/if}>Percentage of the customer's CPW</option>
                                    <option value="fixed" {if $formValues.EDITOR_CPW_TYPE == 'fixed'}selected=""{/if}>Fixed amount</option>
                                </select>
                            </div>
                        </div>

                        <div id="editor_cpw_type">
                            <div class="switch-combo {if $formValues.EDITOR_CPW_TYPE != 'fixed'}x-hidden{/if}" data-combo-value="fixed">
                                <div class="form-group form-row">
                                    <label class="col-sm-4 control-label text-left">Cost Per Word</label>
                                    <div class="col-sm-8">
                                        <input class="form-control force-integer" type="text" name="editor_cost_per_word" value="{$formValues.EDITOR_AMOUNT_CPW}">
                                        <span class="help-block">The amount the editor will earn per word</span>
                                    </div>
                                </div>
                            </div>
                            <div class="switch-combo {if $formValues.EDITOR_CPW_TYPE != 'percentage'}x-hidden{/if}" data-combo-value="percentage">
                                <div class="form-group form-row">
                                    <label class="col-sm-4 control-label text-left">Cost Per Word</label>
                                    <div class="col-sm-8">
                                        <input class="form-control force-integer" type="text" name="editor_percent_per_word" value="{$formValues.EDITOR_PERCENTAGE_CPW}">
                                        <span class="help-block">
                                            The Percentage the editor will earn from the customer's CPW
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="divider"></div>
                    {/if}

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Writer Category</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="writer_category_cost" value="{$formValues.EDITOR_W_CATEGORY_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost charged for "Writer Category"
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Complex Assignment</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="complex_assignment_cost" value="{$formValues.EDITOR_COMPLEX_ASSIGNMENT_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost charged for a complex assignment
                            </span>
                        </div>
                    </div>

                    <div class="divider"></div>
                    
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Copy of Sources</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="used_sources_cost" value="{$formValues.EDITOR_USED_SOURCES_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost of the "Copy of Sources" Service
                            </span>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Progressive Delivery</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="p_delivery_cost" value="{$formValues.EDITOR_PROGRESSIVE_DELIVERY_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost of the "Progressive Delivery" Service
                            </span>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Editor Samples</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="writer_sample_cost" value="{$formValues.EDITOR_PROVIDE_ME_SAMPLES_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost of the "Get Editor Samples" Service
                            </span>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Expert Proofreading</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="expert_proofreading_cost" value="{$formValues.EDITOR_EXPERT_PROOFREADING_COST}">
                            <span class="help-block">
                                The percentage the editor will earn from the customer's additional cost of the "Expert Proofreading" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">VIP Support</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="vip_support_cost" value="{$formValues.EDITOR_VIP_SUPPORT_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "VIP Support" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Plagiarism Report</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="plagiarism_report_cost" value="{$formValues.EDITOR_PLAGIARISM_REPORT_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Plagiarism Report" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-4 control-label text-left">Draft/Outline</label>
                        <div class="col-sm-8">
                            <input class="form-control force-integer" type="text" name="draft_outline_cost" value="{$formValues.EDITOR_DRAFT_OUTLINE_COST}">
                            <span class="help-block">
                                The percentage the writer will earn from the customer's additional cost of the "Draft/Outline" Service
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-8 offset-sm-4">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <!-- Editor Payments -->

    </div>
</div>
{/block}