{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon with-nav">
        <div class="mb20">
            <i class="fa fa-cog mr10"></i>
            <strong>Settings</strong>
        </div>

        <!-- tabs nav -->
        <ul class="nav nav-tabs admin">
            <li class="nav-item">
                <a class="nav-link active"href="#general" data-toggle="tab">
                    <i class="fa fa-server fa-fw mr5"></i>
                    <strong class="pr5">General</strong>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link"href="#email" data-toggle="tab">
                    <i class="fa fa-envelope fa-fw mr5"></i>
                    <strong class="pr5">Email</strong>
                </a>
            </li>

        </ul>
        <!-- tabs nav -->
    </div>

    <div class="card-body">
        <!-- tabs content -->
        <div class="tab-content">

            <!-- General -->
            <div class="tab-pane active" id="general">
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/settings?edit=general_settings">
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Site ID</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" value="{$formValues.SITE_ID}" readonly>
                            <span class="help-block">
                                Your administrator site ID
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Website Logo</label>
                        <div class="col-sm-9">
                            {if $site_logo == ''}
                                <div class="x-image">
                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_logo" value="">
                                </div>
                            {else}
                                <div class="x-image" style="background-image: url('{$uploads_path}/{$site_logo}')">
                                    <button type="button" class="close js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_logo" value="{$site_logo}">
                                </div>
                            {/if}
                            <span class="help-block">
                                The perfect size for your logo should be (width: 130px & height: 50px)
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Site Favicon</label>
                        <div class="col-sm-9">
                            {if $formValues.SITE_FAVICON == ''}
                                <div class="x-image">
                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_favicon" value="">
                                </div>
                            {else} 
                                <div class="x-image" style="background-image: url('{$uploads_path}/{$formValues.SITE_FAVICON}')">
                                    <button type="button" class="close js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_favicon" value="{$formValues.SITE_FAVICON}">
                                </div>
                            {/if}
                            <span class="help-block">
                                The perfect size for your favicon should be (width: 196px & height: 196px)
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Email Logo</label>
                        <div class="col-sm-9">
                            {if $formValues.SITE_EMAIL_LOGO == ''}
                                <div class="x-image">
                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_email_logo" value="">
                                </div>
                            {else}
                                <div class="x-image" style="background-image: url('{$uploads_path}/{$formValues.SITE_EMAIL_LOGO}')">
                                    <button type="button" class="close js_x-image-remover" title='Remove'>
                                        <span>×</span>
                                    </button>
                                    <div class="loader loader_small x-hidden"></div>
                                    <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                    <input type="hidden" class="js_x-image-input" name="site_email_logo" value="{$formValues.SITE_EMAIL_LOGO}">
                                </div>
                            {/if}
                            <span class="help-block">
                                The perfect size for your logo should be (width: 130px & height: 50px)
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Website Title
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="site_name" value="{$formValues.SITE_NAME}">
                            <span class="help-block">
                                Title of your website
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Website Domain
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="site_domain" value="{$formValues.SITE_DOMAIN}">
                            <span class="help-block">
                                URL of your website
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Website Email
                        </label>
                        <div class="col-sm-9">
                            <input type="email" class="form-control" name="site_email" value="{$formValues.SITE_EMAIL}">
                            <span class="help-block">
                                The contact email that all messages send to
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Notification Emails</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="notification_emails" value="{$formValues.NOTIFICATION_EMAILS}">
                            <span class="help-block">
                                Additional contact emails that will receive notifications. Separate by a comma <strong>,</strong>
                            </span>
                        </div> 
                    </div>
                    
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Lifetime of dashboard cookies</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control force-integer" name="cookie_lifetime" value="{$formValues.COOKIE_LIFETIME}">
                            <span class="help-block">
                                Set the amount of hours during which the dashboard cookies are valid. After that amount of time, the employee will have to log in again.
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Default Timezone
                        </label>
                        <div class="col-md-4">
                            <select id="timezone-region" class="form-control" data-combo="timezone-combo">
                                {foreach from=$regions item=region key=key name=name}
                                    <option value="{$key}" {if $default_region == $key } selected="" {/if} >{$key}</option>
                                {/foreach}
                            </select>
                        </div>
                        <div id="timezone-combo" class="col-md-5">
                            {foreach from=$regions item=region key=key name=name}
                                <select id="timezone-combo-{$key}" class="form-control {if $default_region != $key } x-hidden {/if} switch-combo" data-combo-value="{$key}">
                                    {foreach from=$region item=item key=key name=name}
                                        <option value="{$key}" {if $default_timezone == $key } selected="" {/if} >{$item}</option>
                                    {/foreach}
                                </select>
                            {/foreach}
                        </div>
                    </div>
                    <input type="hidden" id="timezone" name="default_timezone" data-content="timezone" data-highlight="#timezone-region" value="{$default_timezone}">

                    <div class="divider"></div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Registration Enabled</div> 
                            <div class="form-text">Allow users to create accounts</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="registration_enabled"> 
                                <input type="checkbox" name="registration_enabled" id="registration_enabled" {if $formValues.REGISTRATION_ENABLED}checked{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-table-row">
                        <div>
                            <div class="form-control-label h5">Cookie Consent (GDPR)</div>
                            <div class="form-text">Turn the cookie consent notification On and Off</div>
                        </div>
                        <div class="text-right"> 
                            <label class="switch" for="cookie_consent_enabled"> 
                                <input type="checkbox" name="cookie_consent_enabled" id="cookie_consent_enabled"  {if $formValues.COOKIE_CONSENT_ENABLED}checked{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div>
                    </div>

                    <div class="divider"></div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label h5">Enable Customization</div> 
                            <div class="form-text">Turn the customization On and Off</div> 
                        </div> 
                        <div class="text-right"> 
                            <label class="switch" for="css_customize"> 
                                <input type="checkbox" name="css_customize" id="css_customize" {if $formValues.CSS_CUSTOMIZE}checked{/if}> 
                                <span class="slider round"></span> 
                            </label> 
                        </div> 
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Header Color</label>
                        <div class="col-sm-9">
                            <div class="input-group js_colorpicker">
                                <input name="header_color" type="text" class="form-control" value="{$formValues.HEADER_COLOR}">
                                <span class="input-group-append"> 
                                    <span class="input-group-text colorpicker-input-addon"><i></i></span>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Button Primary</label>
                        <div class="col-sm-9">
                            <div class="input-group js_colorpicker">
                                <input name="btn_primary_color" type="text" class="form-control" value="{$formValues.BUTTON_PRIMARY}">
                                <span class="input-group-append"> 
                                    <span class="input-group-text colorpicker-input-addon"><i></i></span>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Menu Background</label>
                        <div class="col-sm-9">
                            <div class="input-group js_colorpicker">
                                <input name="menu_background_color" type="text" class="form-control" value="{$formValues.MENU_BACKGROUND}">
                                <span class="input-group-append"> 
                                    <span class="input-group-text colorpicker-input-addon"><i></i></span>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">Custom CSS</label>
                        <div class="col-sm-9">
                            <textarea class="form-control js_autosize" rows="10" name="custom_css" id="custom-css">{$formValues.CUSTOM_CSS nofilter}</textarea>
                            <span class="help-block">Header Custom CSS
                            </span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>
                    
                </form>
            </div>
            <!-- General -->

            <!-- Email -->
            <div class="tab-pane" id="email">
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/settings?edit=email_settings">

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">
                            Mail Method
                        </label>
                        <div class="col-sm-9">
                            <div class="radio radio-primary"> 
                                <input type="radio" name="mail_method" value="1" id="mail_method_1" {if $formValues.MAIL_METHOD == '1'}checked="checked"{/if}> 
                                <label for="mail_method_1">Use PHP's mail() (recommended)</label> 
                            </div>
                            <div class="radio radio-primary"> 
                                <input type="radio" name="mail_method" value="2" id="mail_method_2" {if $formValues.MAIL_METHOD == '2'}checked="checked"{/if}> 
                                <label for="mail_method_2">Set my own SMTP parameters</label> 
                            </div>
                            <div class="radio radio-primary"> 
                                <input type="radio" name="mail_method" value="3" id="mail_method_3" {if $formValues.MAIL_METHOD == '3'}checked="checked"{/if}> 
                                <label for="mail_method_3">Never send emails</label> 
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            SMTP server
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="smtp_server" value="{$formValues.MAIL_SERVER}">
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            SMTP username
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="smtp_username" value="{$formValues.MAIL_USER}">
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            SMTP password
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="smtp_password" value="{$formValues.MAIL_PASSWD}">
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Port
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="smtp_port" value="{$formValues.MAIL_SMTP_PORT}">
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label">
                            Encryption
                        </label>
                        <div class="col-sm-9">
                            <div class="form-selectgroup">
                                <label class="form-selectgroup-item" for="smtp_encryption_off">
                                    <input id="smtp_encryption_off" type="radio" name="smtp_encryption" value="off" class="form-selectgroup-input" {if $formValues.MAIL_SMTP_ENCRYPTION == 'off'}checked{/if}>
                                    <span class="form-selectgroup-label">
                                        <i class="icon fas fa-unlock fa-lg"></i>    
                                        <span class="text middle">None</span>
                                    </span>
                                </label>
                                <label class="form-selectgroup-item" for="smtp_encryption_ssl">
                                    <input id="smtp_encryption_ssl" type="radio" name="smtp_encryption" value="ssl" class="form-selectgroup-input" {if $formValues.MAIL_SMTP_ENCRYPTION == 'ssl'}checked{/if}>
                                    <span class="form-selectgroup-label">
                                        <i class="icon fab fa-expeditedssl fa-lg"></i>    
                                        <span class="text middle">SSL</span>
                                    </span>
                                </label>
                                <label class="form-selectgroup-item" for="smtp_encryption_tls">
                                    <input id="smtp_encryption_tls" type="radio" name="smtp_encryption" value="tls" class="form-selectgroup-input" {if $formValues.MAIL_SMTP_ENCRYPTION == 'tls'}checked{/if}>
                                    <span class="form-selectgroup-label">
                                        <i class="icon fas fa-shield-alt fa-lg"></i>    
                                        <span class="text middle">TLS</span>
                                    </span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </div>

                </form>
            </div>
            <!-- Email -->

        </div>
        <!-- tabs content -->

    </div>
</div>
{/block}