{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fas fa-sync mr10"></i>
            <strong>System Updates</strong>
        </div>

        <div class="card-body">
            {if $last_version_check}
                <p>Last checked on {$last_version_check}. &nbsp; <a class="btn btn-default" href="{$base_uri}/updates?force-check=1">Check Again</a></p>
            {/if}

            {if $check_for_update}
                {if $update_available}
                    <p>A newer version of Proxim is available: <strong>{$new_update_version}</strong></p>
                    <a class="btn btn-primary" href="{$base_uri}/upgrader">Install Update</a>
                {else}
                    <p>You have the latest version of Proxim: <strong>{$system_version}</strong></p>
                {/if}
            {else}
                <p>Your current Proxim version: <strong>{$system_version}</strong></p>
                <a class="btn btn-primary" href="{$base_uri}/updates?force-check=1">Check for Updates</a>
            {/if}
            
        </div>
    </div>

    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-globe mr10"></i>
            <strong>My Sites</strong>
        </div>

        <div class="card-body">
            {if count($sites)}
                <div class="table-responsive">
                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                <td>Site Name</td>
                                <td>Version</td>
                                <td>Last Update</td>
                                <td>Actions</td>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $sites as $site}
                                <tr>
                                    <td><a href="{$base_uri}/my-sites/{$site.id}/edit">{$site.name}</a></td>
                                    <td>{$site.version}</td>
                                    <td>
                                        <span class="js_moment" data-time="{$site.last_update}">{$site.last_update}</span>
                                    </td>
                                    <td>
                                        <a target="_blank" href="{$site.domain}/updates?force-check=1" class="btn btn-xs btn-success">
                                            <i class="fa fa-sync"></i> Update
                                        </a>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>
                </div>
            {else}
                <div class="text-center x-muted"> 
                    <i class="fa fa-globe fa-4x"></i>
                    <p class="mb10"><strong>No sites to show</strong></p>
                </div>
            {/if}
        </div>
    </div>

    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-stopwatch mr10"></i>
            <strong>Changelog</strong>
        </div>

        <div class="card-body">
            {include file="updates/changelog.tpl"}
        </div>
    </div>
{/block}