<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Exception;

use \Exception;

/**
 * @since 1.0.0
 */
class ProximException extends Exception {

    /**
     * This method acts like an error handler, if dev mode is on, display the error else use a better silent way
     */
    public function displayMessage() {

        header('HTTP/1.1 500 Internal Server Error');

        // Log the error in the disk
        exit;
    }


}