<?php 
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Module;

use Db;
use Exception;
use Proxim\Application;
use Proxim\Cache\Cache;
use Proxim\Configuration;
use Proxim\Hook;
use Proxim\Order\Meta;
use Proxim\Tools;
use Proxim\Validate;

abstract class PaymentModule extends Module
{
    public $currencies = true;

    const DEBUG_MODE = false;

    /**
     * List all installed and active payment modules.
     *
     * @see Module::getPaymentModules() if you need a list of module
     *
     * @return array module informations
     */
    public static function getInstalledPaymentModules()
    {
        $hook_payment = 'Payment';
        if (Db::getInstance()->getValue('SELECT `hook_id` FROM ' .  Db::prefix('hook') . 's WHERE `name` = \'paymentOptions\'')) {
            $hook_payment = 'paymentOptions';
        }

        return Db::getInstance()->executeS('
            SELECT DISTINCT m.`module_id`, h.`hook_id`, m.`name`, hm.`position`
            FROM ' .  Db::prefix('module') . ' m
            LEFT JOIN ' .  Db::prefix('hook_module') . ' hm ON hm.`module_id` = m.`module_id`
            LEFT JOIN ' .  Db::prefix('hook') . ' h ON hm.`hook_id` = h.`hook_id`
            WHERE h.`name` = \'' . pSQL($hook_payment) . '\'
        ');
    }
}