<?php
/**
 * @package    Proxim 
 * @author     Davison Pro <davis@davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Order;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Cache\Cache;
use Proxim\ObjectModel;
use Proxim\User\Customer;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;
use Proxim\Tools;

/**
 * AdditionalService
 */
class AdditionalService extends ObjectModel
{
    const START_ID = 344245;

	/** @var $id AdditionalService ID */
	public $id;

	/** @var int order_id */
    public $order_id;

    /** @var string comment */
    public $comment;

    /** @var int tariff_id */
    public $tariff_id;

    /** @var int writer_category_id */
    public $writer_category_id;

    /** @var int pages */
    public $pages = 0;

    /** @var int charts */
    public $charts = 0;

    /** @var int slides */
    public $slides = 0;

    /** @var bool writer_samples */
    public $writer_samples = 0;

    /** @var bool used_sources */
    public $used_sources = 0;

    /** @var bool expert_proofreading */
    public $expert_proofreading = 0;

    /** @var bool progressive_delivery */
    public $progressive_delivery = 0;

    /** @var float total */
    public $total = 0;

    /** @var string paid_at */
    public $paid_at;

    /** @var bool is_paid */
    public $is_paid = 0;
    
	/** @var string date_add */
	public $date_add;
	
	/** @var string date_upd */
    public $date_upd;

	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'additional_service',
        'primary' => 'additional_service_id',
        'fields' => array(
            'order_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'comment' => array('type' => self::TYPE_STRING),
            'tariff_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'writer_category_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'pages' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'charts' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'slides' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'writer_samples' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'used_sources' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'expert_proofreading' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'progressive_delivery' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'total' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice'),
            'paid_at' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'is_paid' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
		)
	);

	/**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null)
    {
        parent::__construct($id);
	}

    public function add($autodate = true, $null_values = true) {
        $next_service_id = Db::getInstance()->getValue('SELECT MAX(`additional_service_id`)+1 FROM `' . DB_PREFIX . 'additional_service`');
        if (!$next_service_id) {
            $next_service_id = self::START_ID;
        }

        $this->id = $next_service_id;
        $this->force_id = true;

        return parent::add($autodate, $null_values);
    }
}