<?php
/**
 * @package    Proxim 
 * @author     Davison Pro <davis@davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Order;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Cache\Cache;
use Proxim\ObjectModel;
use Proxim\User\Customer;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;
use Proxim\Tools;

/**
 * Bid
 */
class Bid extends ObjectModel
{
	/** @var $id Bid ID */
	public $id;

	/** @var int order_id */
	public $order_id;

	/** @var int writer_id */
    public $writer_id;
    
    /** @var int bid_time */
    public $bid_time = 0;
    
    /** @var int amount */
    public $amount = 0;
    
    /** @var bool is_assigned */
    public $is_assigned = 0;
    
    /** @var bool is_deleted */
	public $is_deleted = 0;
	
	/** @var string date_add */
	public $date_add;
	
	/** @var string date_upd */
    public $date_upd;

	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'order_bid',
        'primary' => 'bid_id',
        'fields' => array(
			'order_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
			'writer_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'bid_time' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'amount' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice'),
            'is_assigned' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_deleted' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
		)
	);

	/**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null)
    {
        parent::__construct($id);
	}
}