<?php
/**
 * @package    Proxim 
 * @author     Davison Pro <davis@davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Order;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Cache\Cache;
use Proxim\ObjectModel;
use Proxim\User\Customer;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;
use Proxim\Tools;

/**
 * OrderEmployee
 */
class OrderEmployee extends ObjectModel
{
	/** @var $id OrderEmployee ID */
	public $id;

    /** @var int order_id */
    public $order_id;

    /** @var int employee_id */
    public $employee_id;

    /** @var int hrs_employee */
    public $hrs_employee = 0;

    /** @var string employee_deadline */
    public $employee_deadline;

    /** @var float employee_pay */
    public $employee_pay = 0;

    /** @var string employee_paid_at */
    public $employee_paid_at;

    /** @var bool is_employee_paid */
    public $is_employee_paid = 0;

    /** @var bool is_auto_assigned */
    public $is_auto_assigned = 0;

    /** @var bool is_employee_assigned */
    public $is_employee_assigned = 0;

    /** @var string employee_assigned_at */
    public $employee_assigned_at;

    /** @var bool is_employee_confirmed */
    public $is_employee_confirmed = 0;

     /** @var string employee_confirmed_at */
     public $employee_confirmed_at;

    /** @var bool is_employee_declined */
    public $is_employee_declined = 0;

    /** @var string employee_declined_at */
    public $employee_declined_at;

    /** @var bool is_completed */
    public $is_completed = 0;

    /** @var bool is_delivered */
    public $is_delivered = 0;

    /** @var bool is_approved */
    public $is_approved = 0;

    /** @var bool is_cancelled */
    public $is_cancelled = 0;

    /** @var bool is_revised */
    public $is_revised = 0;

    /** @var bool is_disputed */
    public $is_disputed = 0;

    /** @var bool is_refunded */
    public $is_refunded = 0;

    /** @var bool is_late */
    public $is_late = 0;

	/** @var string date_add */
	public $date_add;
	
	/** @var string date_upd */
    public $date_upd;

	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'order_employee',
        'primary' => 'order_employee_id',
        'fields' => array(
            'order_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'employee_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'hrs_employee' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'employee_deadline' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'employee_pay' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice'),
            'is_employee_paid' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'employee_paid_at' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'is_auto_assigned' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_employee_assigned' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'employee_assigned_at' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'is_employee_confirmed' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'employee_confirmed_at' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'is_employee_declined' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'employee_declined_at' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'is_completed' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_delivered' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_approved' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_cancelled' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_revised' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_disputed' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_refunded' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_late' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
		)
	);

	/**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null)
    {
        parent::__construct($id);
	}
}