<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Order;

use Db;
use Proxim\ObjectModel;

class OrderState extends ObjectModel
{
    /** @var $id OrderState ID */
	public $id;

    /** @var string Name */
    public $name;

    /** @var string Description */
    public $description;

    /** @var string Template name if there is any e-mail to send */
    public $template;

    /** @var bool Send an e-mail to customer ? */
    public $send_email;

    public $module_name;

    /** @var bool Allow customer to view and download invoice when order is at this state */
    public $invoice;

    /** @var string Display state in the specified color */
    public $color;

    public $unremovable;

    /** @var bool Log authorization */
    public $logable;

    /** @var bool Delivery */
    public $delivery;

    /** @var bool Hidden */
    public $hidden;

    /** @var bool Shipped */
    public $shipped;

    /** @var bool Paid */
    public $paid;

    /** @var bool Attach PDF Invoice */
    public $pdf_invoice;

    /** @var bool Attach PDF Delivery Slip */
    public $pdf_delivery;

    /** @var bool True if carrier has been deleted (staying in database as deleted) */
    public $deleted = 0;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = [
        'table' => 'order_state',
        'primary' => 'order_state_id',
        'fields' => [
            'name' => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true, 'size' => 64],
            'description' => ['type' => self::TYPE_STRING, 'validate' => 'isString'],
            'template' => ['type' => self::TYPE_STRING, 'validate' => 'isTplName', 'size' => 64],
            'send_email' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'module_name' => ['type' => self::TYPE_STRING, 'validate' => 'isModuleName'],
            'invoice' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'color' => ['type' => self::TYPE_STRING, 'validate' => 'isColor'],
            'logable' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'shipped' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'unremovable' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'delivery' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'hidden' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'paid' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'pdf_delivery' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'pdf_invoice' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'deleted' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool']
        ]
    ];

    const FLAG_NO_HIDDEN = 1;  /* 00001 */
    const FLAG_LOGABLE = 2;  /* 00010 */
    const FLAG_DELIVERY = 4;  /* 00100 */
    const FLAG_SHIPPED = 8;  /* 01000 */
    const FLAG_PAID = 16; /* 10000 */

    /**
     * Get all available order statuses.
     *
     * @return array Order statuses
     */
    public static function getOrderStates()
    {
        $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS('
            SELECT *
            FROM ' . Db::prefix('order_state') . ' os
            WHERE deleted = 0
            ORDER BY `name` ASC
        ');

        return $result;
    }
}