<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Order;

use Proxim\ObjectModel;
use Proxim\Validate;
use Proxim\Tools;

/**
 * PayPalPayment
 */
class PayPalPayment extends ObjectModel
{
    const STATE_FAKE = 0;

    const STATE_COMPLETE = 1;

    const STATE_REFUND = 2;

    const TYPE_ADD_PAYMENT = 'add-payment';

    const TYPE_ORDER = 'order';

    /** @var $id PayPalPayment ID */
    public $id;

    /** @var int status_id */
    public $status_id = self::STATE_FAKE;
    
    /** @var string node_type */
    public $node_type = self::TYPE_ORDER;
	
    /** @var int node_id */
    public $node_id;

    /** @var float amount */
    public $amount = 0;
	
	/** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
    public $date_add;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'paypal_payment',
        'primary' => 'payment_id',
        'fields' => array(
            'status_id' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'node_type' => array('type' => self::TYPE_STRING),
            'node_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'amount' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice'),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
        )
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null)
    {
        parent::__construct($id);
	}
}
