<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Order;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Cache\Cache;
use Proxim\ObjectModel;
use Proxim\User\Customer;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;
use Proxim\Tools;

/**
 * Rating
 */
class Rating extends ObjectModel
{
    const USER_CUSTOMER = 'customer';
    const USER_EMPLOYEE = 'employee';

	/** @var $id Rating ID */
	public $id;
	
    /** @var int order_id */
	public $order_id;

    /** @var string user_type */
	public $user_type = self::USER_CUSTOMER;

    /** @var int user_id */
	public $user_id;

	/** @var int paper_rating */
	public $paper_rating = 0;
	
	/** @var int service_rating */
	public $service_rating = 0;
	
	/** @var string comment */
	public $comment;

	/** @var bool paper_on_time */
	public $paper_on_time = 0;

	/** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'order_rating',
        'primary' => 'rating_id',
        'fields' => array(
            'order_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'user_type' => array('type' => self::TYPE_STRING),
            'user_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'paper_rating' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'service_rating' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'comment' => array('type' => self::TYPE_STRING),
            'paper_on_time' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
        ),
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null) {
		parent::__construct($id);
    }
    
    public function present( $fullInfo = false ) {
        $feedback = array(
            'id' => (int) $this->id,
            'order_id' => (int) $this->order_id,
            'user_type' => $this->user_type,
            'user_id' => (int) $this->user_id,
            'paper_rating' => toFixed($this->paper_rating/2, 1),
            'service_rating' => toFixed($this->service_rating/2, 1),
            'paper_on_time' => (bool) $this->paper_on_time,
            'comment' => Tools::nl2br($this->comment),
            'date' => $this->date_add
        );

        if($fullInfo) {
            $order = new Order( $this->order_id );
            $feedback['order'] = $order->present();
        }

        return $feedback;
    }

}