<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Preference;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Cache\Cache;
use Proxim\ObjectModel;
use Proxim\Order\Order;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;
use Proxim\Tools;

/**
 * PaperType
 */
class PaperType extends ObjectModel
{
	/** @var $id PaperType ID */
    public $id;

    /** @var string title */
    public $title;

    /** @var int is_academic_writing */
    public $is_academic_writing = 0;

    /** @var int is_article_writing */
    public $is_article_writing = 0;

    /** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'paper_type',
        'primary' => 'paper_type_id',
        'fields' => array( 
            'title' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true, 'size' => 255),
            'is_academic_writing' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'is_article_writing' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        ),
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null) {
		parent::__construct($id);
    }
    
    /**
     * Return paper types by site ID.
     *
     * @return array PaperTypes
     */
    public static function getPaperTypes( $orderServiceType = Order::COMPLEX_ASSIGNMENT )
    {
        $sql = new DbQuery();
        $sql->select('pt.*');
        $sql->from('paper_type', 'pt');

        switch($orderServiceType) {
            case Order::ARTICLE_WRITING:
                $sql->where('pt.is_article_writing = 1');
                break;

            case Order::COMPLEX_ASSIGNMENT:
            default:
                $sql->where('pt.is_academic_writing = 1');
                break;
        }

        $sql->orderBy('pt.paper_type_id ASC');

        $result = Db::getInstance()->executeS($sql);
        
        return $result;
    }
}