<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Preference;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Cache\Cache;
use Proxim\ObjectModel;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;
use Proxim\Tools;

/**
 * UploadType
 */
class UploadType extends ObjectModel
{
	/** @var $id UploadType ID */
    public $id;

    /** @var string title */
    public $title;

    /** @var int writer */
    public $writer = 0;

    /** @var int customer */
    public $customer = 0;

    /** @var int editor */
    public $editor = 0;
    
    /** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'upload_type',
        'primary' => 'upload_type_id',
        'fields' => array( 
            'title' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true, 'size' => 255),
            'writer' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'customer' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'editor' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        ),
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null) {
        parent::__construct($id);
    }
    
    /**
     * Return upload types by site ID.
     *
     * @param bool $siteId
     *
     * @return array UploadTypes
     */
    public static function getUploadTypes()
    {
        $sql = new DbQuery();
        $sql->select('ut.*');
        $sql->from('upload_type', 'ut');
        $sql->orderBy('ut.upload_type_id ASC');
        $result = Db::getInstance()->executeS($sql);
        return $result;
    }
}