<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Preference;

use Db;
use Proxim\Database\DbQuery;
use Proxim\ObjectModel;

/**
 * WritingGuide
 */
class WritingGuide extends ObjectModel
{
    const TYPE_FAQ = 'faq';

    const TYPE_PAYMENT = 'payment';

    const TYPE_WRITING = 'writing';

	/** @var $id WritingGuide ID */
    public $id;

    /** @var string type */
    public $type;

    /** @var string title */
    public $title;

    /** @var string guide */
    public $guide;

    /** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'writing_guide',
        'primary' => 'writing_guide_id',
        'fields' => array( 
            'type' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true, 'size' => 20),
            'title' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true, 'size' => 255),
            'guide' => array('type' => self::TYPE_HTML, 'validate' => 'isCleanHtml', 'required' => true),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        ),
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null) {
        parent::__construct($id);
    }
    
    /**
     * Return writing guides
     *
     * @return array WritingGuides
     */
    public static function getWritingGuides( $type = self::TYPE_WRITING )
    {
        $sql = new DbQuery();
        $sql->select('wg.*');
        $sql->from('writing_guide', 'wg');
        $sql->where('wg.`type` = \'' . pSQL($type) . '\'');
        $sql->orderBy('wg.writing_guide_id ASC');
        $result = Db::getInstance()->executeS($sql);
        return $result;
    }
}