<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Preference;

use Db;
use Proxim\Database\DbQuery;
use Proxim\ObjectModel;

/**
 * WritingPrompt
 */
class WritingPrompt extends ObjectModel
{
	/** @var $id WritingPrompt ID */
    public $id;

    /** @var string title */
    public $title;

    /** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'writing_prompt',
        'primary' => 'writing_prompt_id',
        'fields' => array( 
            'title' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true, 'size' => 255),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        ),
    );

    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null) {
        parent::__construct($id);
    }
    
    /**
     * Return writing prompts
     *
     * @return array WritingPrompts
     */
    public static function getWritingPrompts()
    {
        $sql = new DbQuery();
        $sql->select('wp.*');
        $sql->from('writing_prompt', 'wp');
        $sql->orderBy('wp.writing_prompt_id DESC');
        $result = Db::getInstance()->executeS($sql);
        return $result;
    }
}