<?php 
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2020 Proxim
 * @version    1.0
 * @since      File available since Release 1.0
*/

namespace Proxim\Presenter\Object;

use Exception;
use Proxim\ObjectModel;
use Proxim\Presenter\PresenterInterface;

class ObjectPresenter implements PresenterInterface
{
    /**
     * @param ObjectModel $object
     *
     * @return array
     *
     * @throws Exception
     */
    public function present($object)
    {
        if (!($object instanceof ObjectModel)) {
            throw new Exception('ObjectPresenter can only present ObjectModel classes');
        }

        $presentedObject = array();

        $fields = $object::$definition['fields'];
        foreach ($fields as $fieldName => $null) {
            $presentedObject[$fieldName] = $object->{$fieldName};
        }
        
        $presentedObject['id'] = $object->id;

        $mustRemove = ['deleted', 'active'];
        foreach ($mustRemove as $fieldName) {
            if (isset($presentedObject[$fieldName])) {
                unset($presentedObject[$fieldName]);
            }
        }

        $this->filterHtmlContent($object::$definition['table'], $presentedObject, $object->getHtmlFields());

        return $presentedObject;
    }

    /**
     * Execute filterHtml hook for html Content for objectPresenter.
     *
     * @param $type
     * @param $presentedObject
     * @param $htmlFields
     */
    private function filterHtmlContent($type, &$presentedObject, $htmlFields)
    {
        if (!empty($htmlFields) && is_array($htmlFields)) {
            // if (!empty($filteredHtml['object'])) {
            //     $presentedObject = $filteredHtml['object'];
            // }
        }
    }
}
