<?php 
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2020 Proxim
 * @version    1.0
 * @since      File available since Release 1.0
*/

namespace Proxim\Presenter\Order;

use Exception;
use Proxim\Order\Message as OrderMessage;
use Proxim\Presenter\PresenterInterface;

class OrderMessagePresenter implements PresenterInterface
{
    /**
     * @param orderMessage $orderMessage
     *
     * @return OrderMessagePresenter
     *
     * @throws Exception
     */
    public function present($orderMessage)
    {
        if (!($orderMessage instanceof OrderMessage)) {
            throw new Exception('OrderMessagePresenter can only present instance of OrderMessage');
        }

        return new OrderMessageLazyArray($orderMessage);
    }
}