<?php 
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2020 Proxim
 * @version    1.0
 * @since      File available since Release 1.0
*/

namespace Proxim\Presenter\Order;

use Exception;
use Proxim\Order\Order;
use Proxim\Presenter\PresenterInterface;

class OrderPresenter implements PresenterInterface
{
    /**
     * @param Order $order
     *
     * @return OrderLazyArray
     *
     * @throws Exception
     */
    public function present($order)
    {
        if (!($order instanceof Order)) {
            throw new Exception('OrderPresenter can only present instance of Order');
        }

        switch($order->service_type) {
            case Order::PROGRAMMING:
            case Order::CALCULATIONS:
                return new CalculationsOrderLazyArray($order);
                break;

            case Order::ARTICLE_WRITING:
                return new ArticlesOrderLazyArray($order);
                break;

            case Order::COMPLEX_ASSIGNMENT:
            default:
                return new AcademicOrderLazyArray($order);
                break;
        }
    }
}