<?php 
/**
 * The base configuration for Proxim
 * @package    Proxim
 * @author     Davison Pro <davisonpro.coder@gmail.com | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.0.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim;

use Proxim\Tools;
use \NumberFormatter;
use Proxim\Currency;

/**
 * Format a price depending on locale and currency.
 */
class PriceFormatter
{
    /**
     * @param float $price
     * @param string|null $currency
     *
     * @return string
     */
    public function format($price, $currency = null)
    {
        if (is_int($currency)) {
            $currency = Currency::getCurrencyInstance($currency);
        }
        
        $currencyCode = is_array($currency) ? $currency['iso_code'] : $currency->iso_code;

        $formatter = new NumberFormatter('en_US',  NumberFormatter::CURRENCY);

        return $formatter->formatCurrency($price, $currencyCode);
    }
}