<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\User;

use Proxim\ObjectModel;

/**
 * EmployeeFile
 */
class EmployeeFile extends ObjectModel
{
	/** @var $id File ID */
	public $id;

	/** @var int employee_id */
	public $employee_id;

	/** @var int uploader_id */
	public $uploader_id;

	/** @var string handle */
	public $handle;
	
	/** @var string description */
	public $description;
	
	/** @var string name */
	public $name;
	
	/** @var int size */
	public $size = 0;
	
	/** @var string source */
	public $source;
	
	/** @var string extension */
	public $extension;
	
	/** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;

	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'employee_file',
        'primary' => 'employee_file_id',
        'fields' => array(
			'employee_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
			'uploader_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
			'handle' => array('type' => self::TYPE_STRING, 'size' => 255, 'required' => true),
			'description' => array('type' => self::TYPE_STRING, 'size' => 255),
			'name' => array('type' => self::TYPE_STRING),
			'size' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
			'source' => array('type' => self::TYPE_STRING),
			'extension' => array('type' => self::TYPE_STRING),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
			'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
		)
	);

	/**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null)
    {
		parent::__construct($id);
	}
}
