<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Api;

use Db;
use Proxim\Addon\Theme\ThemeManager;
use Proxim\Addon\Theme\ThemeManagerBuilder;
use Proxim\Controller;
use Proxim\Util\ArrayUtils;

class Themes extends Controller {
    public function doAction() {
        $app = $this->app;
        $payload = $app->request->post();
        $controller = $app->controller;
        $user = $app->user;

        $do = ArrayUtils::get($payload, 'do');
        $themeName = ArrayUtils::get($payload, 'theme_name');

        switch($do) {
            case 'install':
                if(!(new ThemeManagerBuilder($app, Db::getInstance()))->build()->enable($themeName)) {
                    return $controller->modal("ERROR", "Error", "The theme could not be installed");
                }

                return $controller->modal("SUCCESS", "Update Theme", "Theme updated successfully");
                break;

            default:
                return $this->response([
                    "error" => true,
                    "message" => "Error 404. Resource not found"
                ]);
                break;
        }
    }
}