<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Api;

use Db;
use Exception;
use Proxim\Database\DbQuery;
use Proxim\Configuration;
use Proxim\Mail;
use Proxim\Tools;
use Proxim\Validate;
use Proxim\Controller;
use Proxim\Order\Order;
use Proxim\User\Employee;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Crypto\Hashing;
use Proxim\Hook;

class Updates extends Controller {

    public function getLiveData() {
        $app = $this->app;
        $this->assignVariables();
        $payload = $app->request->post();
        $user = $app->user;
        $smarty = $app->smarty;

        /* if (last_message || last_notification) not set */
        $last_message = (int) ArrayUtils::get($payload, 'last_message');
        $last_notification = (int) ArrayUtils::get($payload, 'last_notification');

        // initialize the return array
        $return = array(
            'success' => true
        );

        $hookResp = Hook::exec('actionBeforeLiveData', $payload, null, true);
        if(is_array($hookResp) && !empty($hookResp)) {
            foreach($hookResp as $resp) {
                $return = array_merge($return, $resp);
            }
        }

        // [2] check for new notifications
        $notifications = $user->getNotifications(0, $last_notification );

        if(count($notifications) > 0) {
            /* assign variables */
            $smarty->assign('notifications', $notifications);
            /* return */
            $return['notifications_json'] = $notifications;
            $return['notifications_count'] = count($notifications);
            $return['notifications'] = $smarty->fetch("ajax.live.notifications.tpl");
        }

        // [3] check for new messages
        if($last_message != $user->live_messages_lastid) {
            $messages = $user->getMessages(0, $last_message );

            if(count($messages) > 0) {
                /* assign variables */
                $smarty->assign('messages', $messages);
                /* return */
                $return['messages_json'] = $messages;
                $return['messages_count'] = count($messages);
                $return['messages'] = $smarty->fetch("ajax.live.messages.tpl");
            }
        }

        // [5] check for new version
        try {
            $update = $app->checkVersion();
            if($update) {
                $return['new_version'] = $update['version'];
            }
        } catch(Exception $e) {
            $return['new_version'] = false;
        }
 
        $hookResp = Hook::exec('actionAfterLiveData', $payload, null, true);
        if(is_array($hookResp) && !empty($hookResp)) {
            foreach($hookResp as $resp) {
                $return = array_merge($return, $resp);
            }
        }
        
        return $this->response($return);
    }

    public function load() {
        $app = $this->app;
        $this->assignVariables();

        $payload = $app->request->post();
        $user = $app->user;
        $smarty = $app->smarty;

        $get = ArrayUtils::get($payload, 'get');
        $offset = (int) ArrayUtils::get($payload, 'offset');

        // initialize the return array
        $return = $data = array();

        $hookBeforeLoadResult = Hook::exec('loadMoreBefore', [
            'get' => $get,
            'offset' => $offset,
            'payload' => $payload
        ], null, true);

        if (is_array($hookBeforeLoadResult)) {
            foreach ($hookBeforeLoadResult as $result) {
                if(isset($result['append'])) {
                    $return['append'] = $result['append'];
                }

                if(isset($result['data'])) {
                    $return['data'] = $result['data'];
                }
            }
        }

        // initialize the attach type
	    $append = true;

        /* get notifications */
        if ( $get == "notifications" ) {
            $data = $user->getNotifications($offset);

        /* get user reviews */
        } elseif( $get == "user_reviews" ) {
            $data = $user->getReviews($offset);

        }
        
        // handle data
        if(count($data) > 0) {
            /* assign variables */
            $smarty->assign('offset', $offset );
            $smarty->assign('get', $get );
            $smarty->assign('data', $data);
            /* return */
            $return['append'] = $append;
            $return['data'] = $smarty->fetch("ajax.load_more.tpl");
        }

        Hook::exec('loadMoreAfter', [
            'get' => $get,
            'offset' => $offset
        ]);

        return $this->response($return);
    }

    public function reset() {
        $app = $this->app;
        $payload = $app->request->post();
        $user = $app->user;

        $counter = ArrayUtils::get($payload, 'reset');

        if ($counter == "notifications") {
            $user->live_notifications_counter = 0;
            $user->update();

            if($user->is_admin) {
                Db::getInstance()->update(
                    'notification', 
                    array('is_seen' => 1), 
                    'to_user_id = ' . (int) $user->id . ' AND to_department = ' . DEPARTMENT_SUPPORT 
                );
            } else {
                Db::getInstance()->update(
                    'notification', 
                    array('is_seen' => 1), 
                    'to_user_id = ' . (int) $user->id . ' AND to_department = ' . DEPARTMENT_WRITER 
                );
            }

        } elseif ( $counter == "messages" ) {
            $user->live_messages_counter = 0;
            $user->update();
        }

        return $this->response([
            "success" => true,
        ]);
    }

    public function autocomplete() {
        $app = $this->app;
        $user = $app->user;
        $smarty = $app->smarty;
        $payload = $app->request->post();

        $type = ArrayUtils::get($payload, 'type');
        $query = ArrayUtils::get($payload, 'query');
        $skipped_ids = ArrayUtils::get($payload, 'skipped_ids', array());

        if($skipped_ids) {
            $skipped_ids = json_decode($skipped_ids);
            if(is_array($skipped_ids)) {
                /* skipped_ids must contain numeric values only */
                $skipped_ids = array_filter($skipped_ids, 'is_numeric');
            }
        }

        // initialize the return array
	    $return = array();

        $smarty->assign('type', $type);

        switch($type) {
            case 'employee':
                
                /* get employees */
                $sql = new DbQuery();
                $sql->select('employee_id, first_name, last_name, gender, avatar');
                $sql->from('employee', 'e');
                $sql->where('employee_id != ' . (int) $user->id );

                if(is_array($skipped_ids) && count($skipped_ids)) {
                    /* make a skipped list (including the viewer) */
                    $skipped_list = implode(',', $skipped_ids);
                    $sql->where('employee_id NOT IN ('. $skipped_list .')');
                }

                $sql->where('(first_name LIKE \'%' . pSQL($query) . '%\' OR last_name LIKE  \'%' . pSQL($query) . '%\'  OR CONCAT(first_name,  " ", last_name) LIKE  \'%' . pSQL($query) . '%\' )');
                $result = Db::getInstance()->executeS($sql);

                $employees = array();
                if(count($result)) {
                    foreach( $result as $employee ) {
                        $employee = new Employee( (int) $employee['employee_id'] );
                        if(Validate::isLoadedObject($employee)) {
                            $employees[] = (array) $employee;
                        }
                        
                    }
                }

		        $smarty->assign('employees', $employees);

                /* return */
		        $return['autocomplete'] = $smarty->fetch("ajax.autocomplete.tpl");

                break;
            
            case 'customer':

                break;
        }

        return $this->response($return);
    }
}