<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Api;

use Proxim\Controller;
use Proxim\User\Employee;
use Proxim\User\EmployeePool;
use Proxim\Util\ArrayUtils;
use Proxim\Validate;

class WriterPools extends Controller {

    public function post() {
        $app = $this->app;
        $payload = $app->request->post();
        $user = $app->user;

        $insert = true;
        if(ArrayUtils::has($payload, 'pool_id')) {
            $pool_id = ArrayUtils::get($payload, 'pool_id');
            $pool = new EmployeePool( (int) $pool_id  );
            if(!Validate::isLoadedObject($pool)) {
                return $this->response([
                    "error" => true,
                    "message" => "Writer pool does not exist"
                ]);
            }

            $insert = false;
        } else {
            $pool = new EmployeePool();
        }
 
        $name = ArrayUtils::get($payload, 'name');
        $description = ArrayUtils::get($payload, 'description');
        $badge = ArrayUtils::get($payload, 'badge');
        $status = ArrayUtils::get($payload, 'status');
        $order = (int) ArrayUtils::get($payload, 'order');
        $academic_level = (int) ArrayUtils::get($payload, 'academic_level');
        $writer_category = (int) ArrayUtils::get($payload, 'writer_category');

        $takes = (int) ArrayUtils::get($payload, 'takes');
        $bids = (int) ArrayUtils::get($payload, 'bids');
        $base_price = (int) ArrayUtils::get($payload, 'base_price');
        $price_per_page = (float) ArrayUtils::get($payload, 'price_per_page');
        $price_per_word = (float) ArrayUtils::get($payload, 'price_per_word');

        $requirements = ArrayUtils::get($payload, 'requirements');
        $benefits = ArrayUtils::get($payload, 'benefits');

        if(!$name || !Validate::isGenericName($name)) {
            return $this->response([
                'error' => true,
                'message' => 'Please enter the name'
            ]);	
        }

        $pool->name = $name;
        $pool->description = $description;
        $pool->badge = $badge;
        $pool->status = $status;
        $pool->order = $order;
        $pool->academic_level = $academic_level;
        $pool->writer_category = $writer_category;

        $pool->takes = $takes;
        $pool->bids = $bids;
        $pool->base_price = $base_price;
        $pool->price_per_page = $price_per_page;
        $pool->price_per_word = $price_per_word;

        $pool->requirements = $requirements;
        $pool->benefits = $benefits;
        $pool->urgent_orders = ArrayUtils::has($payload, 'urgent_orders');
        $pool->auto_delivery = ArrayUtils::has($payload, 'auto_delivery');
        $pool->new_customers = ArrayUtils::has($payload, 'new_customers');
        $pool->is_default = ArrayUtils::has($payload, 'is_default');

        if($insert) {
            $pool->add();

            return $this->response([
                'callback' => 'window.location.href="/pools/view/'.$pool->id.'";'
            ]);
        } else {
            $pool->update();

            if(ArrayUtils::has($payload, 'writer_ids')) {
                $writer_ids = ArrayUtils::get($payload, 'writer_ids', []);

                foreach($writer_ids as $writer_id) {
                    $writer = new Employee((int) $writer_id);
                    if(Validate::isLoadedObject($writer)) {
                        $writer->employee_pool_id = $pool->id;
                        $writer->update();
                    }
                }
            }

            return $this->response([
                "success" => true,
                "message" => "Writer pool has been updated successfully"
            ]);
        }
    }

    public function addwriter() {
        $app = $this->app;
        $payload = $app->request->post();
        $user = $app->user;

        $pool_id = (int) ArrayUtils::get($payload, 'pool_id');
        $writer_id = (int) ArrayUtils::get($payload, 'writer_id');

        $pool = new EmployeePool( (int) $pool_id  );
        if(!Validate::isLoadedObject($pool)) {
            return $this->modal("ERROR", "Not Found", "Writer pool does not exist"); 
        }

        $writer = new Employee((int) $writer_id);
        if(!Validate::isLoadedObject($writer)) {
            return $this->modal("ERROR", "Not Found", "Writer does not exist"); 
        }

        if($writer->employee_pool_id == $pool->id) {
            $writer->employee_pool_id = 0;
        } else {
            $writer->employee_pool_id = $pool->id;
        }
        $writer->update();

        return $this->response([
            "success" => true
        ]);
    }
}