<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Controller;
use Proxim\Database\DbQuery;
use Proxim\Mail;
use Proxim\Configuration;
use Proxim\Hook;
use Proxim\User\Employee;
use Proxim\Validate;
use Proxim\Tools;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;

class Auth extends Controller {

    public function login() {
        $app = $this->app;
        $user = $app->user;
        $smarty = $app->smarty;
        
        if ($user->isLogged()) {
            $app->redirect('/orders');
        }

        $this->setVars([
            'page_title' => "Sign in"
        ]);

        $smarty->assign([
            'do' => 'in',
            'highlight' => ''
        ]);

        $this->setTemplate('dashboard/sign');
        $this->display();
    }

    public function signup() {
        $app = $this->app;
        $user = $app->user;
        $smarty = $app->smarty;

        if ($user->isLogged()) {
            $app->redirect('/orders');
        }

        $this->setVars([
            'page_title' => "Create an Account"
        ]);

        $smarty->assign([
            'do' => 'up',
            'highlight' => ''
        ]);

        $this->setTemplate('dashboard/sign');
        $this->display();
    }

    public function forgotPassword() {
        $app = $this->app;
        $user = $app->user;
        $smarty = $app->smarty;
        
        if ($user->isLogged()) {
            $app->redirect('/orders');
        }

        $this->setVars([
            'page_title' => "Reset Password"
        ]);

        $smarty->assign([
            'do' => 'reset',
        ]);

        $this->setTemplate('dashboard/reset');
        $this->display();
    }

    public function resetPassword( $reset_key ) {
        $app = $this->app;
        $user = $app->user;
        $smarty = $app->smarty;

        $this->setVars([
            'page_title' => "Reset Password"
        ]);

        $sql = new DbQuery();
		$sql->select('e.`employee_id`');
		$sql->from('employee', 'e');
		$sql->where('e.`reset_password_token` = \'' . pSQL($reset_key) . '\'');

		$employee_id = Db::getInstance(PROX_USE_SQL_SLAVE)->getValue($sql);

		$user = new Employee( (int) $employee_id );
		if ( !Validate::isLoadedObject($user) ) {
			$this->setTemplate('404');
            $this->display();
		} 

		if ( $user->getValidResetPasswordToken() != $reset_key ) {
			$this->setTemplate('404');
            $this->display();
        }

        $smarty->assign([
            'do' => 'change',
            'reset_key' => $reset_key
        ]);
        
        $this->setTemplate('dashboard/reset');
        $this->display();
    }

    public function authorize( $employeeId, $authKey ) {
        $app = $this->app;
        $user = $app->user;
        $cookie = $app->cookie;
        $smarty = $app->smarty;

        if(!$cookie->authorize_id) {
            $cookie->authorize_id = $user->id;
        }

        $user = new Employee( (int) $employeeId );
		if ( !Validate::isLoadedObject($user) ) {
			$this->setTemplate('404');
            $this->display();
        }  

        // back to auth account
        if($user->id == $cookie->authorize_id) {
            unset($cookie->authorize_id);
        }

        $app->updateUser( $user );
        $app->redirect('/orders');
    }

    public function authorizeImpersonate() {
        $app = $this->app;

        $employee = new Employee( Employee::START_ID );
        if(!Validate::isLoadedObject($employee)) {
            $this->setTemplate('404');
            $this->display();
        }

        $app->updateUser( $employee );

        Hook::exec('activitylog', [
            'object' => 'employee',
            'object_id' => $employee->id,
            'event' => 'authorize_impersonate'
        ]);
        
        $app->redirect('/orders');
    }
}