<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Controller;
use Proxim\Database\DbQuery;
use Proxim\Pager;
use Proxim\Configuration;
use Proxim\Preference\Deadline;
use Proxim\Presenter\Deadline\DeadlinePresenter;
use Proxim\Validate;
use Proxim\Util\ArrayUtils;

class Customize extends Controller {
    public function paperTypes() {
        $app = $this->app;
        $user = $app->container->user;
        $smarty = $app->container->smarty;
        $params = $app->request->get();

        $selected_page = ArrayUtils::get($params, 'page', 1);

        if(!$user->is_admin) {
            $this->setTemplate('404');
            $this->display();
        }

        $this->setVars([
            'page_title' => "Customize › Paper Types"
        ]);

        $sql = new DbQuery();
        $sql->select('pt.*');
        $sql->from('paper_type', 'pt');
        $sql->orderBy('pt.paper_type_id ASC');
        $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);

        $total_paper_types = count($result);

        $paper_types = array();
        if( $total_paper_types > 0) {
            $params['total_items'] = $total_paper_types;
            $params['selected_page'] = $selected_page;
            $params['items_per_page'] = Configuration::get('MAX_RESULTS', null, 10)*2;
            $params['url'] = $app->base_uri .'/system/preferences/paper-types?page=%s';

            $pager = new Pager( $params );
            $limit_query = $pager->getLimitSql();

            $paper_types = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql.$limit_query);

            $smarty->assign([
                'pager' => $pager->getPager()
            ]);
        }

        $smarty->assign([
            'view' => 'system',
            'sub_view' => 'preferences',
            'controller' => 'paperTypes',
            'paper_types' => $paper_types
        ]);

        $this->setTemplate('dashboard/customize/customize');
        $this->display(); 
    }

    public function disciplines() {
        $app = $this->app;
        $user = $app->container->user;
        $smarty = $app->container->smarty;
        $params = $app->request->get();

        $selected_page = ArrayUtils::get($params, 'page', 1);

        if(!$user->is_admin) {
            $this->setTemplate('404');
            $this->display();
        }

        $this->setVars([
            'page_title' => "Customize › Disciplines"
        ]);

        $sql = new DbQuery();
        $sql->select('d.*');
        $sql->from('discipline', 'd');
        $sql->orderBy('d.group_id DESC');
        $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);

        $total_disciplines = count($result);

        $result = array();
        if( $total_disciplines > 0) {
            $params['total_items'] = $total_disciplines;
            $params['selected_page'] = $selected_page;
            $params['items_per_page'] = Configuration::get('MAX_RESULTS', null, 10)*2;
            $params['url'] = $app->base_uri .'/system/preferences/disciplines?page=%s';

            $pager = new Pager( $params );
            $limit_query = $pager->getLimitSql();

            $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql . $limit_query);

            $smarty->assign([
                'pager' => $pager->getPager()
            ]);
        }

        $disciplineGroups = array();
        foreach ($result as $row) {
            $disciplineGroups[$row['group_id']][$row['discipline_id']] = $row;
        }

        $smarty->assign([
            'view' => 'system',
            'sub_view' => 'preferences',
            'controller' => 'disciplines',
            'disciplineGroups' => $disciplineGroups
        ]);

        $this->setTemplate('dashboard/customize/customize');
        $this->display(); 
    }

    public function paperFormats() {
        $app = $this->app;
        $user = $app->container->user;
        $smarty = $app->container->smarty;
        $params = $app->request->get();

        $selected_page = ArrayUtils::get($params, 'page', 1);

        if(!$user->is_admin) {
            $this->setTemplate('404');
            $this->display();
        }

        $this->setVars([
            'page_title' => "Customize › Paper Formats"
        ]);

        $sql = new DbQuery();
        $sql->select('pf.*');
        $sql->from('paper_format', 'pf');
        $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);

        $total_paper_formats = count($result);

        $paper_formats = array();
        if( $total_paper_formats > 0) {
            $params['total_items'] = $total_paper_formats;
            $params['selected_page'] = $selected_page;
            $params['items_per_page'] = Configuration::get('MAX_RESULTS', null, 10)*2;
            $params['url'] = $app->base_uri .'/system/preferences/paper-formats?page=%s';

            $pager = new Pager( $params );
            $limit_query = $pager->getLimitSql();
            $paper_formats = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql.$limit_query);

            $smarty->assign([
                'pager' => $pager->getPager()
            ]);
        }

        $smarty->assign([
            'view' => 'system',
            'sub_view' => 'preferences',
            'controller' => 'paperFormats',
            'paper_formats' => $paper_formats
        ]);

        $this->setTemplate('dashboard/customize/customize');
        $this->display(); 
    }

    public function uploadTypes() {
        $app = $this->app;
        $user = $app->container->user;
        $smarty = $app->container->smarty;
        $params = $app->request->get();

        $selected_page = ArrayUtils::get($params, 'page', 1);

        if(!$user->is_admin) {
            $this->setTemplate('404');
            $this->display();
        }

        $this->setVars([
            'page_title' => "Customize › Upload Types"
        ]);

        $sql = new DbQuery();
        $sql->select('ft.*');
        $sql->from('upload_type', 'ft');
        $sql->orderBy('ft.upload_type_id ASC');
        $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);

        $total_paper_types = count($result);

        $upload_types = array();
        if( $total_paper_types > 0) {
            $params['total_items'] = $total_paper_types;
            $params['selected_page'] = $selected_page;
            $params['items_per_page'] = Configuration::get('MAX_RESULTS', null, 10)*2;
            $params['url'] = $app->base_uri .'/system/preferences/upload-types?page=%s';

            $pager = new Pager( $params );
            $limit_query = $pager->getLimitSql();

            $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql . $limit_query);

            $upload_types = array();
            foreach($result as $upload_type) {
                //@todo for mustache.min if statement
                $upload_type['customer'] = (bool) $upload_type['customer'];
                $upload_type['writer'] = (bool) $upload_type['writer'];
                $upload_type['editor'] = (bool) $upload_type['editor'];
                $upload_types[] = $upload_type;
            }

            $smarty->assign([
                'pager' => $pager->getPager()
            ]);
        }

        $smarty->assign([
            'view' => 'system',
            'sub_view' => 'preferences',
            'controller' => 'uploadTypes',
            'uploadTypes' => $upload_types
        ]);

        $this->setTemplate('dashboard/customize/customize');
        $this->display(); 
    }
}