<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Controller;
use Proxim\Database\DbQuery;
use Proxim\Pager;
use Proxim\Currency;
use Proxim\Site\Site;
use Proxim\Configuration;
use Proxim\Order\Order;
use Proxim\Order\Rating;
use Proxim\Preference\WritingGuide;
use Proxim\User\Employee;
use Proxim\Validate;
use Proxim\Tools;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;

class Guides extends Controller {
    public function writing() {
        $app = $this->app;
        $user = $app->user;
        $params = $app->request->get();
        $smarty = $app->smarty;

        $this->setVars([
            'page_title' => "Guides › Writing Guide"
        ]);

        $writing_guides = WritingGuide::getWritingGuides(WritingGuide::TYPE_WRITING);

        $smarty->assign([
            'writing_guides' => $writing_guides
        ]);

        $this->setTemplate('dashboard/guides/writing');
        $this->display();
    }

    public function payment() {
        $app = $this->app;
        $user = $app->user;
        $params = $app->request->get();
        $smarty = $app->smarty;


        $this->setVars([
            'page_title' => "Guides › Payment Guide"
        ]);

        $payment_guides = WritingGuide::getWritingGuides(WritingGuide::TYPE_PAYMENT);

        $smarty->assign([
            'payment_guides' => $payment_guides
        ]);

        $this->setTemplate('dashboard/guides/payment');
        $this->display();
    }

    public function faq() {
        $app = $this->app;
        $user = $app->user;
        $params = $app->request->get();
        $smarty = $app->smarty;

        $this->setVars([
            'page_title' => "Guides › FAQ"
        ]);

        $faqs = WritingGuide::getWritingGuides(WritingGuide::TYPE_FAQ);

        $smarty->assign([
            'faqs' => $faqs
        ]);

        $this->setTemplate('dashboard/guides/faq');
        $this->display();
    }
}