<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Proxim\Configuration;
use Proxim\Controller;

class Home extends Controller {
    public function index() {
        $app = $this->app;
        $user = $app->user;
        $params = $app->request->get();
        $smarty = $app->smarty;

        $this->setVars([
            'page_title' => Configuration::get('SITE_NAME') . " - Best Freelance Writing Jobs Online!"
        ]);

        $this->setTemplate('dashboard/home');
        $this->display();
    }
}