<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Controller;
use Proxim\Database\DbQuery;
use Proxim\Mail;
use Proxim\Configuration;
use Proxim\Hook;
use Proxim\Pager;
use Proxim\Preference\ApplicationEssay;
use Proxim\Preference\Discipline;
use Proxim\Preference\WritingGuide;
use Proxim\Preference\WritingPrompt;
use Proxim\Presenter\Object\ObjectPresenter;
use Proxim\User\Employee;
use Proxim\Validate;
use Proxim\Tools;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;

class Info extends Controller { 
    public function guide( $sub_view = 'writing-guide' ) {
        $app = $this->app;
        $user = $app->user; 
        $params = $app->request->get();
        $smarty = $app->smarty;

        if( !$user->is_admin && !$user->is_sub_admin ) {
            $this->setTemplate('404');
            $this->display();
        }

        switch($sub_view) {
            case 'writing-guide':
            case 'payment-guide':
            case 'faqs':

                $this->setVars([
                    'page_title' => "Writing Guides"
                ]); 

                $selected_page = ArrayUtils::has($params, 'page') ? (int) ArrayUtils::get($params, 'page') : 1;

                $sql = new DbQuery();
                $sql->select('wg.writing_guide_id');
                $sql->from('writing_guide', 'wg');

                if($sub_view == 'writing-guide') {
                    $sql->where('wg.`type` = \'' . pSQL(WritingGuide::TYPE_WRITING) . '\'');
                } elseif ($sub_view == 'payment-guide') {
                    $sql->where('wg.`type` = \'' . pSQL(WritingGuide::TYPE_PAYMENT) . '\'');
                } elseif ($sub_view == 'faqs') {
                    $sql->where('wg.`type` = \'' . pSQL(WritingGuide::TYPE_FAQ) . '\'');
                }

                $sql->orderBy('wg.writing_guide_id DESC');
                $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);

                $guides = array();
                $total_guides = count($result);

                if( $total_guides > 0) {
                    $params['total_items'] = $total_guides;
                    $params['selected_page'] = $selected_page;
                    $params['items_per_page'] = Configuration::get('MAX_RESULTS', null, 10)*2;
                    $params['url'] = '/info/'.$sub_view.'?page=%s';

                    $pager = new Pager( $params );
                    $limit_query = $pager->getLimitSql();

                    $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql.$limit_query);

                    $objectPresenter = new ObjectPresenter();
                    foreach( $result as $writing_guide ) {
                        $writing_guide = new WritingGuide( (int) $writing_guide['writing_guide_id'] );
                        if( Validate::isLoadedObject($writing_guide) ) {
                            $guides[] = $objectPresenter->present($writing_guide);
                        }
                    }

                    $smarty->assign([
                        'pager' => $pager->getPager()
                    ]);
                }

                $smarty->assign([
                    'total_guides' => $total_guides,
                    'guides' => $guides
                ]);
                
                break;

            case 'software-programming':
                $this->setVars([
                    'page_title' => "Software & Programming"
                ]); 

                $selected_page = ArrayUtils::has($params, 'page') ? (int) ArrayUtils::get($params, 'page') : 1;

                $sql = new DbQuery();
                $sql->select('sp.*');
                $sql->from('software_programming', 'sp');
                $sql->orderBy('sp.software_programming_id DESC');
                $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);

                $rows = array();
                $total_rows = count($result);

                if( $total_rows > 0) {
                    $params['total_items'] = $total_rows;
                    $params['selected_page'] = $selected_page;
                    $params['items_per_page'] = Configuration::get('MAX_RESULTS', null, 10)*2;
                    $params['url'] = '/info/'.$sub_view.'?page=%s';

                    $pager = new Pager( $params );
                    $limit_query = $pager->getLimitSql();
                    $rows = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS( $sql . $limit_query );

                    $smarty->assign([
                        'pager' => $pager->getPager()
                    ]);
                }

                $smarty->assign([
                    'total_rows' => $total_rows,
                    'rows' => $rows
                ]);
                break;

            default:
                $this->setTemplate('404');
                $this->display();
                break;
        }

        $smarty->assign([
            'view' => 'info',
            'sub_view' => $sub_view
        ]);

        $this->setTemplate('dashboard/info/guides');
        $this->display();
    }

    public function addGuide( $sub_view ) {
        $app = $this->app;
        $user = $app->user;
        $params = $app->request->get();
        $smarty = $app->smarty;

        if( !$user->is_admin && !$user->is_sub_admin ) {
            $this->setTemplate('404');
            $this->display();
        }

        $this->setVars([
            'page_title' => "Writing Guide › Add"
        ]); 

        $objectPresenter = new ObjectPresenter();

        $smarty->assign([
            'view' => 'info',
            'sub_view' => $sub_view,
        ]);

        $this->setTemplate('dashboard/info/guides.add');
        $this->display();
    }

    public function editGuide( $sub_view, $writingGuideId ) {
        $app = $this->app;
        $user = $app->user;
        $params = $app->request->get();
        $smarty = $app->smarty;

        if( !$user->is_admin && !$user->is_sub_admin ) {
            $this->setTemplate('404');
            $this->display();
        }

        switch($sub_view) {
            case 'writing-guide':
            case 'payment-guide':
            case 'faqs':
            case 'software-programming':
                $writingGuide = new WritingGuide((int) $writingGuideId);
                if(!Validate::isLoadedObject($writingGuide)) {
                    $this->setTemplate('404');
                    $this->display();
                }

                $this->setVars([
                    'page_title' => "Writing Guide › Edit",
                ]); 

                $objectPresenter = new ObjectPresenter();

                $smarty->assign([
                    'view' => 'info',
                    'sub_view' => $sub_view,
                    'guide' => $objectPresenter->present($writingGuide)
                ]);

                $this->setTemplate('dashboard/info/guides.edit');
                $this->display();
                break;

            default:
                $this->setTemplate('404');
                $this->display();
                break;
        }
    }
}