<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Configuration;
use Proxim\Database\DbQuery;
use Proxim\Controller;
use Proxim\Order\Message;
use Proxim\Order\Order;
use Proxim\Pager;
use Proxim\Presenter\Order\OrderMessagePresenter;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;
use Proxim\Validate;

class Messages extends Controller {
    public function getMessages() {
        $app = $this->app;
        $user = $app->user;
        $smarty = $app->smarty;
        $params = $app->request->get();
        $selected_page = ArrayUtils::has($params, 'page') ? (int) ArrayUtils::get($params, 'page') : 1;

        $sql = new DbQuery();
        $sql->select('m.message_id');
        $sql->from('order_message', 'm');
        
        if($user->is_writer) {
            $sql->innerJoin('order', 'o', 'o.order_id = m.order_id AND o.writer_id = ' . (int) $user->id );
            $sql->where(' (m.`from_department` = ' . (int) DEPARTMENT_WRITER . ') OR ( m.`to_department` = ' . (int) DEPARTMENT_WRITER . ' AND is_verified = 1 ) ');
        }  elseif( $user->is_editor ) {
            $sql->innerJoin('order', 'o', 'o.order_id = m.order_id AND o.editor_id = ' . (int) $user->id );
            $sql->where(' (m.`from_department` = ' . (int) DEPARTMENT_WRITER . ') OR ( m.`to_department` = ' . (int) DEPARTMENT_WRITER . ' AND is_verified = 1 ) ');
        } else {
            $sql->innerJoin('order', 'o', 'o.order_id = m.order_id' );
        }

        $sql->orderBy('m.message_id DESC');

        $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);
        $total_messages = count($result);

        $messagePresenter = new OrderMessagePresenter();

        $messages = array();
        if( $total_messages > 0) {
            $params['total_items'] = $total_messages;
            $params['selected_page'] = $selected_page;
            $params['items_per_page'] = Configuration::get('MAX_RESULTS', null, 10)*2;
            $params['url'] = "/messages?page=%s";

            $pager = new Pager( $params );
            $limit_query = $pager->getLimitSql();

            $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql . $limit_query);

            foreach( $result as $message ) {
                $message = new Message( (int) $message['message_id'] );
                if(Validate::isLoadedObject($message)) {
                    $messages[] = $messagePresenter->present($message);
                }
            }

            $smarty->assign([
                'pager' => $pager->getPager()
            ]);
        }

        $this->setVars([
            'page_title' => "Messages"
        ]);

        $smarty->assign([
            'view' => 'messages',
            'sub_view' => '',
            'messages' => $messages,
            'total_messages' => $total_messages
        ]);
         
        $this->setTemplate('dashboard/messages');
        $this->display(); 
    }
}