<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\Dashboard;

use Db;
use Proxim\Database\DbQuery;
use Proxim\Controller;
use Proxim\Pager;
use Proxim\Currency;
use Proxim\Site\Site;
use Proxim\Configuration;
use Proxim\Order\Order;
use Proxim\Preference\AcademicLevel;
use Proxim\Preference\Discipline;
use Proxim\Presenter\Object\ObjectPresenter;
use Proxim\User\Employee;
use Proxim\Validate;
use Proxim\Tools;
use Proxim\User\EmployeeFile;
use Proxim\Util\DateUtils;
use Proxim\Util\ArrayUtils;

class Profile extends Controller {
    public function profile( $_settings = 'general' ) {
        global $globals;

        $app = $this->app;
        $user = $app->user;
        $params = $app->request->get();
        $smarty = $app->smarty;

        $selected_page = ArrayUtils::get($params, 'page', 1);

        $this->setVars([
            'page_title' => "Profile"
        ]);

        $sql = new DbQuery();
        $sql->select('session.*');
        $sql->from('user_session', 'session');
        $sql->where('session.user_id = ' . (int) $user->id );
        $sql->orderBy('session.session_id DESC');
        $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);
 
        $total_sessions = count($result);
        $sessions = array();
        if( $total_sessions > 0) {
            $params['total_items'] = $total_sessions;
            $params['selected_page'] = $selected_page;
            $params['items_per_page'] = Configuration::get('MAX_RESULTS', null, 10)*2;
            $params['url'] = '/settings/sessions?page=%s';

            $pager = new Pager( $params );
            $limit_query = $pager->getLimitSql();
            $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql . $limit_query);

            foreach($result as $session) {
                $session['login_time'] = DateUtils::convertUtcDateTimeToTimeZone($session['date_add'], $user->timezone);
                $sessions[] = $session;
            }

            $smarty->assign([
                'pager' => $pager->getPager()
            ]);
        }

        $countries = $globals['countries'];
        $user_country = ArrayUtils::get($countries, $user->country);

        $sql = new DbQuery();
        $sql->select('ef.employee_file_id');
        $sql->from('employee_file', 'ef');
        $sql->where('ef.employee_id = ' . (int) $user->id );
        $sql->orderBy('ef.employee_file_id DESC');
        $result = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);

        $objectPresenter = new ObjectPresenter();

        $user_files = array();
        foreach($result as $file) {
            $file = new EmployeeFile( (int) $file['employee_file_id'] );
            if(Validate::isLoadedObject($file)) {
                $presentedFile = $objectPresenter->present($file);
                $presentedFile['download_link'] = $app->base_uri . '/api/employee-files/'.$file->id.'/download';
                $presentedFile['size_formatted'] = formatBytes($file->size);
                $user_files[] = $presentedFile;
            }
        }

        # employee files
        $user_files = ArrayUtils::groupByKey($user_files, 'handle');

        # user disciplines
        $user_disciplines = array();
        foreach($user->proficient_disciplines_array as $discipline_id) {
            $discipline = new Discipline((int) $discipline_id);
            if(Validate::isLoadedObject($discipline)) {
                $user_disciplines[] = [
                    'id' => $discipline->id,
                    'title' => $discipline->title
                ];
            }
        }

        # user software & programming
        $user_softwares = array();
        if(!empty($user->software_array)) {
            $user_softwares = Db::getInstance()->executeS('SELECT * FROM ' . DB::prefix('software_programming') . ' WHERE software_programming_id IN ('.implode(',', $user->software_array).')');
        }

        # softwares & programming
        $sql = new DbQuery();
        $sql->select('sp.*');
        $sql->from('software_programming', 'sp');
        $sql->orderBy('sp.software_programming_id DESC');
        $software_programming = Db::getInstance(PROX_USE_SQL_SLAVE)->executeS($sql);

        // languages
        $languages = languages();

        $disciplineGroups = Discipline::getDisciplinesByGroup();
        $academicLevels = AcademicLevel::getAcademicLevels();
        
        $userAbout = Tools::getStringClean($user->about);
        $userAbout = Tools::nl2br($userAbout);

        $writer_outstanding_balance = $user->getOutstanding();

        $smarty->assign([
            'view' => 'profile',
            'sub_view' => 'profile',
            'writer_outstanding_balance' => $writer_outstanding_balance,
            'user_country' => $user_country,
            '_settings' => $_settings,
            'userAbout' => $userAbout,
            'languages' => $languages,
            'countries' => $countries,
            'user_disciplines' => $user_disciplines,
            'user_softwares' => $user_softwares,
            'total_sessions' => $total_sessions,
            'sessions' => $sessions,
            'user_files' => $user_files,
            'user_softwares' => $user_softwares,
            'software_programming' => $software_programming,
            'disciplineGroups' => $disciplineGroups,
            'academicDegrees' => $academicLevels
        ]);
        
        $this->setTemplate('dashboard/profile');
        $this->display(); 
    }
}