<?php
global $globals;

/** Payment Department */
define('DEPARTMENT_PAYMENT', 2);

/** Dispute Department */
define('DEPARTMENT_DISPUTE', 3);

/** Writer Department */
define('DEPARTMENT_WRITER', 6);

/** Customer Department */
define('DEPARTMENT_CUSTOMER', 7);

/** Support Department */
define('DEPARTMENT_SUPPORT', 8);

/** Writers Department */
define('DEPARTMENT_WRITERS', 9);

/** Academic Level HighSchool **/
define('LEVEL_HIGHSCHOOL', 1);
/** Academic Level Undergrad. (yrs 1‑2) **/
define('LEVEL_COLLEGE', 2);
/** Academic Level Undergrad. (yrs 3‑4) **/
define('LEVEL_UNIVERSITY', 3);
/** Academic Level Master's **/
define('LEVEL_MASTERS', 4);
/** Academic Level PhD **/
define('LEVEL_PHD', 5);

/**TaskSize Extra small **/
define('TASKSIZE_EXTRA_SMALL', 1);
/**TaskSize Small **/
define('TASKSIZE_SMALL', 2);
/**TaskSize Medium **/
define('TASKSIZE_MEDIUM', 3);
/**TaskSize Large **/
define('TASKSIZE_LARGE', 4);

$globals['taskSizes'] = array(
    TASKSIZE_EXTRA_SMALL => [
        "title" => "Extra small"
    ],
    TASKSIZE_SMALL => [
        "title" => "Small"
    ],
    TASKSIZE_MEDIUM => [
        "title" => "Medium"
    ],
    TASKSIZE_LARGE => [
        "title" => "Large"
    ]
);

$globals['paperTypes'] = array(
    1 => [
        "title" => "Creative writing",
    ],
    2 => [
        "title" => "Essay (any type)",
    ],
    3 => [
        "title" => "Research paper",
    ],
    4 => [
        "title" => "Speech",
    ],
    5 => [
        "title" => "Book/movie review",
    ],
    6 => [
        "title" => "Term paper",
    ],
    7 => [
        "title" => "Coursework",
    ],
    8 => [
        "title" => "Research proposal",
    ],
    9 => [
        "title" => "Dissertation/Dissertation chapter",
    ],
    10 => [
        "title" => "Thesis/Thesis chapter",
    ],
    11 => [
        "title" => "Business plan",
    ],
    12 => [
        "title" => "Case study",
    ],
    13 => [
        "title" => "Admission essay",
    ],
    14 => [
        "title" => "Article review",
    ],
    15 => [
        "title" => "Annotated bibliography",
    ],
    16 => [
        "title" => "Argumentative essays",
    ],
    18 => [
        "title" => "Critical thinking",
    ],
    35 => [
        "title" => "Capstone project",
    ],
    37 => [
        "title" => "Question-Answer",
    ],
    39 => [
        "title" => "Discussion Essay",
    ],
    41 => [
        "title" => "Summary",
    ],
    43 => [
        "title" => "Literature Analysis/Review",
    ],
    45 => [
        "title" => "Memo/Letter",
    ],
    49 => [
        "title" => "Lab Report",
    ],
    51 => [
        "title" => "Outline",
    ],
    53 => [
        "title" => "Analysis (any type)",
    ],
    55 => [
        "title" => "Presentation/PPT",
    ],
    57 => [
        "title" => "Report (any type)/Brief report",
    ],
    59 => [
        "title" => "Reflection paper/Reflection essay",
    ],
    61 => [
        "title" => "Response essay",
    ],
    63 => [
        "title" => "Personal reflection",
    ],
    64 => [
        "title" => "Other",
    ],
    65 => [
        "title" => "Project",
    ],
    67 => [
        "title" => "Poem",
    ],
    71 => [
        "title" => "Blog post",
    ],
    73 => [
        "title" => "Journal article",
    ],
    74 => [
        "title" => "Article",
    ]
);

$globals['paperFormats'] = array(
    0 => [
        "title" => "MLA",
    ],
    1 => [
        "title" => "APA",
    ],
    2 => [
        "title" => "Chicago / Turabian",
    ],
    3 => [
        "title" => "Not applicable",
    ],
    4 => [
        "title" => "Other",
    ],
);

$globals['uploadTypes'] = array(
    15 => [
        "description" => "Order instructions",
        "writer" => false,
        "customer" => false
    ],
    17 => [
        "description" => "Guidelines for writing",
        "writer" => false,
        "customer" => true
    ],
    19 => [
        "description" => "Outline",
        "writer" => true,
        "customer" => true
    ],
    21 => [
        "description" => "My draft",
        "writer" => true,
        "customer" => true
    ],
    23 => [
        "description" => "Sample of a paper",
        "writer" => true,
        "customer" => true
    ],
    25 => [
        "description" => "Article to be used",
        "writer" => false,
        "customer" => true
    ],
    27 => [
        "description" => "eBook",
        "writer" => false,
        "customer" => true
    ],
    29 => [
        "description" => "Paper with comments for revision/editing",
        "writer" => false,
        "customer" => true
    ],
    31 => [
        "description" => "Proposal",
        "writer" => true,
        "customer" => true
    ],
    39 => [
        "description" => "Other (enter description)",
        "writer" => false,
        "customer" => true
    ],
    51 => [
        "description" => "Questions",
        "writer" => false,
        "customer" => true
    ],
    53 => [
        "description" => "Chapters",
        "writer" => false,
        "customer" => true
    ],
    55 => [
        "description" => "Sources (list)",
        "writer" => true,
        "customer" => true
    ],
    57 => [
        "description" => "Grading rubric",
        "writer" => false,
        "customer" => true
    ],
    59 => [
        "description" => "Lecture notes to be used",
        "writer" => false,
        "customer" => true
    ],
    37 => [
        "description" => "Revision file",
        "writer" => true,
        "customer" => true
    ],
    43 => [
        "description" => "Unselected revision file",
        "writer" => false,
        "customer" => true
    ],
    61 => [
        "description" => "Base revision file",
        "writer" => false,
        "customer" => true
    ],
    65 => [
        "description" => "Completed smart paper file",
        "writer" => true,
        "customer" => true
    ],
    67 => [
        "description" => "Converted paper file",
        "writer" => false,
        "customer" => true
    ],
    68 => [
        "description" => "Screenshot",
        "writer" => false,
        "customer" => false
    ],
    69 => [
        "description" => "Final paper",
        "writer" => true,
        "customer" => false
    ],
);

$globals['disciplines'] = array(
    81 => [
        "name" => "Art (Fine arts, Performing arts)",
        "isComplexAssignment" => 0,
    ],
    10 => [
        "name" => "Classic English Literature",
        "isComplexAssignment" => 0,
    ],
    57 => [
        "name" => "Composition",
        "isComplexAssignment" => 0,
    ],
    56 => [
        "name" => "English 101",
        "isComplexAssignment" => 0,
    ],
    18 => [
        "name" => "Film & Theater studies",
        "isComplexAssignment" => 0,
    ],
    20 => [
        "name" => "History",
        "isComplexAssignment" => 0,
    ],
    59 => [
        "name" => "Linguistics",
        "isComplexAssignment" => 0,
    ],
    41 => [
        "name" => "Literature",
        "isComplexAssignment" => 0,
    ],
    26 => [
        "name" => "Music",
        "isComplexAssignment" => 0,
    ],
    27 => [
        "name" => "Philosophy",
        "isComplexAssignment" => 0,
    ],
    60 => [
        "name" => "Poetry",
        "isComplexAssignment" => 0,
    ],
    31 => [
        "name" => "Religious studies",
        "isComplexAssignment" => 0,
    ],
    34 => [
        "name" => "Shakespeare",
        "isComplexAssignment" => 0,
    ],
    2 => [
        "name" => "Anthropology",
        "isComplexAssignment" => 0,
    ],
    61 => [
        "name" => "Cultural and Ethnic Studies",
        "isComplexAssignment" => 0,
    ],
    15 => [
        "name" => "Economics",
        "isComplexAssignment" => 0,
    ],
    65 => [
        "name" => "Ethics",
        "isComplexAssignment" => 0,
    ],
    29 => [
        "name" => "Political science",
        "isComplexAssignment" => 0,
    ],
    30 => [
        "name" => "Psychology",
        "isComplexAssignment" => 0,
    ],
    54 => [
        "name" => "Social Work and Human Services",
        "isComplexAssignment" => 0,
    ],
    35 => [
        "name" => "Sociology",
        "isComplexAssignment" => 0,
    ],
    64 => [
        "name" => "Tourism",
        "isComplexAssignment" => 0,
    ],
    66 => [
        "name" => "Urban Studies",
        "isComplexAssignment" => 0,
    ],
    40 => [
        "name" => "Women's & gender studies",
        "isComplexAssignment" => 0,
    ],
    1 => [
        "name" => "Accounting",
        "isComplexAssignment" => 1,
    ],
    8 => [
        "name" => "Business Studies",
        "isComplexAssignment" => 0,
    ],
    19 => [
        "name" => "Finance",
        "isComplexAssignment" => 1,
    ],
    75 => [
        "name" => "Human Resources Management (HRM)",
        "isComplexAssignment" => 0,
    ],
    62 => [
        "name" => "International Relations",
        "isComplexAssignment" => 0,
    ],
    63 => [
        "name" => "Logistics",
        "isComplexAssignment" => 0,
    ],
    22 => [
        "name" => "Management",
        "isComplexAssignment" => 0,
    ],
    23 => [
        "name" => "Marketing",
        "isComplexAssignment" => 0,
    ],
    76 => [
        "name" => "Public Relations (PR)",
        "isComplexAssignment" => 0,
    ],
    67 => [
        "name" => "Astronomy (and other Space Sciences)",
        "isComplexAssignment" => 0,
    ],
    42 => [
        "name" => "Biology (and other Life Sciences)",
        "isComplexAssignment" => 1,
    ],
    9 => [
        "name" => "Chemistry",
        "isComplexAssignment" => 1,
    ],
    68 => [
        "name" => "Ecology",
        "isComplexAssignment" => 0,
    ],
    49 => [
        "name" => "Geography",
        "isComplexAssignment" => 0,
    ],
    69 => [
        "name" => "Geology (and other Earth Sciences)",
        "isComplexAssignment" => 0,
    ],
    28 => [
        "name" => "Physics",
        "isComplexAssignment" => 1,
    ],
    45 => [
        "name" => "Zoology",
        "isComplexAssignment" => 0,
    ],
    12 => [
        "name" => "Computer science",
        "isComplexAssignment" => 1,
    ],
    24 => [
        "name" => "Mathematics",
        "isComplexAssignment" => 1,
    ],
    37 => [
        "name" => "Statistics",
        "isComplexAssignment" => 1,
    ],
    70 => [
        "name" => "Agriculture",
        "isComplexAssignment" => 0,
    ],
    3 => [
        "name" => "Application Letters",
        "isComplexAssignment" => 0,
    ],
    5 => [
        "name" => "Architecture, Building and Planning",
        "isComplexAssignment" => 1,
    ],
    71 => [
        "name" => "Aviation",
        "isComplexAssignment" => 0,
    ],
    72 => [
        "name" => "Civil Engineering",
        "isComplexAssignment" => 1,
    ],
    11 => [
        "name" => "Communications",
        "isComplexAssignment" => 0,
    ],
    73 => [
        "name" => "Criminal Justice",
        "isComplexAssignment" => 0,
    ],
    48 => [
        "name" => "Criminal law",
        "isComplexAssignment" => 0,
    ],
    16 => [
        "name" => "Education",
        "isComplexAssignment" => 0,
    ],
    74 => [
        "name" => "Engineering",
        "isComplexAssignment" => 1,
    ],
    50 => [
        "name" => "Environmental studies and Forestry",
        "isComplexAssignment" => 0,
    ],
    17 => [
        "name" => "Family and consumer science",
        "isComplexAssignment" => 0,
    ],
    53 => [
        "name" => "Health Care",
        "isComplexAssignment" => 0,
    ],
    44 => [
        "name" => "International Trade",
        "isComplexAssignment" => 0,
    ],
    39 => [
        "name" => "IT, Web",
        "isComplexAssignment" => 1,
    ],
    21 => [
        "name" => "Law",
        "isComplexAssignment" => 0,
    ],
    77 => [
        "name" => "Leadership Studies",
        "isComplexAssignment" => 0,
    ],
    80 => [
        "name" => "Medical Sciences (Anatomy, Physiology, Pharmacology etc.)",
        "isComplexAssignment" => 0,
    ],
    25 => [
        "name" => "Medicine",
        "isComplexAssignment" => 0,
    ],
    47 => [
        "name" => "Nursing",
        "isComplexAssignment" => 0,
    ],
    78 => [
        "name" => "Nutrition/Dietary",
        "isComplexAssignment" => 0,
    ],
    79 => [
        "name" => "Public Administration",
        "isComplexAssignment" => 0,
    ],
    55 => [
        "name" => "Sports",
        "isComplexAssignment" => 0,
    ],
    38 => [
        "name" => "Technology",
        "isComplexAssignment" => 0,
    ],
    52 => [
        "name" => "Other",
        "isComplexAssignment" => 0,
    ],
);

$globals['disciplinesGroups'] = array(
    0 => array(
        "groupName" => "Humanities",
        "disciplines" => array(
            81, 10, 57, 56, 18, 20, 59, 41, 26, 27, 60, 31, 34
        )
    ),
    1 => array(
        "groupName" => "Social Sciences",
        "disciplines" => array(
            2, 61, 15, 65, 29, 30, 54, 35, 64, 66, 40,
        ),
    ),
    2 => array(
        "groupName" => "Business and administrative studies",
        "disciplines" => array(
            1, 8, 19, 75, 62, 63, 22, 23, 76,
        ),
    ),
    3 => array(
        "groupName" => "Natural Sciences",
        "disciplines" => array(
            67, 42, 9, 68, 49, 69, 28, 45,
        ),
    ),
    4 => array(
        "groupName" => "Formal Sciences",
        "disciplines" => array(
            12, 24, 37,
        ),
    ),
    5 => array(
        "groupName" => "Professions and Applied Sciences",
        "disciplines" => array(
            70, 3, 5, 71, 72, 11, 73, 48, 16, 74, 50, 17, 53, 44, 39, 21, 77, 80, 25, 47, 78, 79, 55, 38
        ),
    ),
    6 => array(
        "groupName" => "Other",
        "disciplines" => array(
            52
        ),
    ),
); 

$globals['workingStatus'] = array(
    2 => [
        "title" => "Looking for orders",
    ],
    4 => [
        "title" => "Cannot work for now", 
    ],
    5 => [
        "title" => "Do not use your service",
    ],
    6 => [
        "title" => "Probation",
    ]
);

$globals['serviceTypes'] = array(
    37 => [
        'title' => 'Academic Writing'
    ],
    42 => [
        'title' => 'Paid Revision (Minor)'
    ],
    43 => [
        'title' => 'Paid Revision (Major)'
    ],
    49 => [
        'title' => 'Resume'
    ],
    50 => [
        'title' => 'Calculations'
    ],
    51 => [
        'title' => 'Programming'
    ],
    52 => [
        'title' => 'Article Writing'
    ]
);

$globals['academicLevels'] = array(
    LEVEL_HIGHSCHOOL => [
        "short_title" => "High school",
        "title" => "High school",
        "degree" => "Highschool Diploma"
    ],
    LEVEL_COLLEGE => [
        "short_title" => "College",
        "title" => "Undergrad. (yrs 1-2)",
        "degree" => "Associate's degree"
    ],
    LEVEL_UNIVERSITY => [
        "short_title" => "University",
        "title" => "Undergrad. (yrs 3-4)",
        "degree" => "Bachelor's degree"
    ],
    LEVEL_MASTERS => [
        "short_title" => "Master's",
        "title" => "Master's",
        "degree" => "Master's degree"
    ],
    LEVEL_PHD => [
        "short_title" => "Ph.D.",
        "title" => "PhD",
        "degree" => "Doctoral degree"
    ]
);

$globals['departments'] = array(
    2 => [
        "name" => "Payment Department",
    ],
    3 => [
        "name" => "Dispute Department",
    ],
    6 => [
        "name" => "Writer",
    ],
    7 => [
        "name" => "Customer",
    ],
    8 => [
        "name" => "Support Department",
    ],
    9 => [
        "name" => "Writers Department",
    ],
);

$globals['interlocutor_departments'] = array(
    DEPARTMENT_CUSTOMER => 'Customer',
    DEPARTMENT_WRITER => 'Writer',
    DEPARTMENT_WRITERS => 'Writers',
    DEPARTMENT_SUPPORT => 'Support',
    DEPARTMENT_PAYMENT => 'Payment',
    DEPARTMENT_DISPUTE => 'Dispute',
);

$globals['writerPreferences'] = array(
    4 => [
        "shortTitle" => "ENL normal", "title" => "ENL (English Native Language)", "percent" => 30, "sampleAvailable" => 1, "description" => "English as a native language writer (US, UK, CA, AU writers)",
    ],
    3 => [
        "shortTitle" => "ESL advanced", "title" => "ESL advanced", "percent" => 25, "sampleAvailable" => 1, "description" => "High-rank professional writer, proficient in the requested field of study",
    ],
    2 => [
        "shortTitle" => "Best", "title" => "Best available", "description" => "Best available",
    ],
);

$globals['orderStatuses'] = array(
    0 => [
        "title" => "Waiting for payment",
        "description" => "Your order is unpaid. Please check your email and follow the tips to complete the payment procedure.",
    ],
    1 => [
        "title" => "Dispute",
        "description" => "",
    ],
    2 => [
        "title" => "Confirmation Pending",
        "description" => "",
    ],
    6 => [
        "title" => "Writer Assigned",
        "description" => "Your order is being processed. The most suitable writer will be assigned shortly. We will notify you of any changes.",
    ],
    7 => [
        "title" => "Writer Accepted",
        "description" => "",
    ],
    8 => [
        "title" => "Done",
        "description" => "",
    ], 
    9 => [
        "title" => "Canceled",
        "description" => "Your order has been cancelled. If you want us to proceed working on it, please, contact the Support Team.",
    ],
    10 => [
        "title" => "Finished",
        "description" => "",
    ],
    11 => [
        "title" => "Delivered",
        "description" => "",
    ],
    12 => [
        "title" => "New Paid",
        "description" => "",
    ],
    13 => [
        "title" => "Free Inquiry",
        "description" => "Your inquiry is unpaid. Please wait - the Support Team will contact you shortly.",
    ],
    14 => [
        "title" => "Revision",
        "description" => "",
    ], 
    15 => [
        "title" => "Reply Pending",
        "description" => "",
    ],
    16 => [
        "title" => "Inquiry Published",
        "description" => "",
    ],
    17 => [
        "title" => "Inquiry Writer Accepted",
        "description" => "",
    ],
    19 => [
        "title" => "Looking for writer",
        "description" => "We have already started to search for the writer to complete your order. Please, check whether you have provided all necessary instructions.",
    ],
    20 => [
        "title" => "Convert Failed",
        "description" => "",
    ],
    21 => [
        "title" => "Call Pending",
        "description" => "",
    ]
);

$globals['deadlines'] = array(
    103171 => [
        "name" => "4 hours", "pricePerPage" => 48, "minPages" => 0, "hrs" => 4, "hrsWriter" => 3, "academicLevel" => LEVEL_UNIVERSITY,
    ],
    54179 => [
        "name" => "8 hours", "pricePerPage" => 38, "minPages" => 0, "hrs" => 8, "hrsWriter" => 7, "academicLevel" => LEVEL_UNIVERSITY,
    ],
    54177 => [ 
            "name" => "24 hours", "pricePerPage" => 29, "minPages" => 0, "hrs" => 24, "hrsWriter" => 20, "academicLevel" => LEVEL_UNIVERSITY,
    ],
    66557 => [
        "name" => "48 hours", "pricePerPage" => 26, "minPages" => 0, "hrs" => 48, "hrsWriter" => 38, "academicLevel" => LEVEL_UNIVERSITY,
    ],
    66555 => [
        "name" => "3 days", "pricePerPage" => 22, "minPages" => 0, "hrs" => 72, "hrsWriter" => 60, "academicLevel" => LEVEL_UNIVERSITY,
    ],
    66553 => [
        "name" => "5 days", "pricePerPage" => 19, "minPages" => 0, "hrs" => 120, "hrsWriter" => 72, "academicLevel" => LEVEL_UNIVERSITY,
    ],
    66551 => [
        "name" => "7 days", "pricePerPage" => 18, "minPages" => 0, "hrs" => 168, "hrsWriter" => 84, "academicLevel" => LEVEL_UNIVERSITY,
    ],
    66549 => [
        "name" => "14 days", "pricePerPage" => 16, "minPages" => 0, "hrs" => 336, "hrsWriter" => 168, "academicLevel" => LEVEL_UNIVERSITY,
    ],
    94531 => [
        "name" => "1 month", "pricePerPage" => 14, "minPages" => 30, "hrs" => 720, "hrsWriter" => 450, "academicLevel" => LEVEL_UNIVERSITY,
    ],
    103159 => [
        "name" => "4 hours", "pricePerPage" => 33, "minPages" => 0, "hrs" => 4, "hrsWriter" => 3, "academicLevel" => LEVEL_HIGHSCHOOL,
    ],
    54151 => [
        "name" => "8 hours", "pricePerPage" => 26, "minPages" => 0, "hrs" => 8, "hrsWriter" => 7, "academicLevel" => LEVEL_HIGHSCHOOL,
    ],
    54149 => [
        "name" => "24 hours", "pricePerPage" => 20, "minPages" => 0, "hrs" => 24, "hrsWriter" => 20, "academicLevel" => LEVEL_HIGHSCHOOL,
    ],
    66537 => [
        "name" => "48 hours", "pricePerPage" => 17, "minPages" => 0, "hrs" => 48, "hrsWriter" => 38, "academicLevel" => LEVEL_HIGHSCHOOL,
    ],
    66535 => [
        "name" => "3 days", "pricePerPage" => 15, "minPages" => 0, "hrs" => 72, "hrsWriter" => 60, "academicLevel" => LEVEL_HIGHSCHOOL,
    ],
    66533 => [
        "name" => "5 days", "pricePerPage" => 14, "minPages" => 0, "hrs" => 120, "hrsWriter" => 72, "academicLevel" => LEVEL_HIGHSCHOOL,
    ],
    66531 => [
        "name" => "7 days", "pricePerPage" => 12, "minPages" => 0, "hrs" => 168, "hrsWriter" => 84, "academicLevel" => LEVEL_HIGHSCHOOL,
    ],
    66529 => [
        "name" => "14 days", "pricePerPage" => 10, "minPages" => 0, "hrs" => 336, "hrsWriter" => 168, "academicLevel" => LEVEL_HIGHSCHOOL,
    ],
    103165 => [
        "name" => "4 hours", "pricePerPage" => 40, "minPages" => 0, "hrs" => 4, "hrsWriter" => 3, "academicLevel" => LEVEL_COLLEGE,
    ],
    54165 => [
        "name" => "8 hours", "pricePerPage" => 32, "minPages" => 0, "hrs" => 8, "hrsWriter" => 7, "academicLevel" => LEVEL_COLLEGE,
    ],
    54163 => [
        "name" => "24 hours", "pricePerPage" => 26, "minPages" => 0, "hrs" => 24, "hrsWriter" => 20, "academicLevel" => LEVEL_COLLEGE,
    ],
    66547 => [
        "name" => "48 hours", "pricePerPage" => 22, "minPages" => 0, "hrs" => 48, "hrsWriter" => 38, "academicLevel" => LEVEL_COLLEGE,
    ],
    66545 => [
        "name" => "3 days", "pricePerPage" => 19, "minPages" => 0, "hrs" => 72, "hrsWriter" => 60, "academicLevel" => LEVEL_COLLEGE,
    ],
    66543 => [
        "name" => "5 days", "pricePerPage" => 16, "minPages" => 0, "hrs" => 120, "hrsWriter" => 72, "academicLevel" => LEVEL_COLLEGE,
    ],
    66541 => [
        "name" => "7 days", "pricePerPage" => 15, "minPages" => 0, "hrs" => 168, "hrsWriter" => 84, "academicLevel" => LEVEL_COLLEGE,
    ],
    66539 => [
        "name" => "14 days", "pricePerPage" => 13, "minPages" => 0, "hrs" => 336, "hrsWriter" => 168, "academicLevel" => LEVEL_COLLEGE,
    ],
    54193 => [
        "name" => "8 hours", "pricePerPage" => 46, "minPages" => 0, "hrs" => 8, "hrsWriter" => 7, "academicLevel" => LEVEL_MASTERS,
    ],
    54191 => [
        "name" => "24 hours", "pricePerPage" => 37, "minPages" => 0, "hrs" => 24, "hrsWriter" => 20, "academicLevel" => LEVEL_MASTERS,
    ],
    66567 => [
        "name" => "48 hours", "pricePerPage" => 32, "minPages" => 0, "hrs" => 48, "hrsWriter" => 38, "academicLevel" => LEVEL_MASTERS,
    ],
    66565 => [
        "name" => "3 days", "pricePerPage" => 27, "minPages" => 0, "hrs" => 72, "hrsWriter" => 60, "academicLevel" => LEVEL_MASTERS,
    ],
    66563 => [
        "name" => "5 days", "pricePerPage" => 25, "minPages" => 0, "hrs" => 120, "hrsWriter" => 72, "academicLevel" => LEVEL_MASTERS,
    ],
    66561 => [
        "name" => "7 days", "pricePerPage" => 23, "minPages" => 0, "hrs" => 168, "hrsWriter" => 84, "academicLevel" => LEVEL_MASTERS,
    ],
    66559 => [
        "name" => "14 days", "pricePerPage" => 21, "minPages" => 0, "hrs" => 336, "hrsWriter" => 168, "academicLevel" => LEVEL_MASTERS,
    ],
    94529 => [
        "name" => "1 month", "pricePerPage" => 19, "minPages" => 30, "hrs" => 720, "hrsWriter" => 450, "academicLevel" => LEVEL_MASTERS,
    ],
    54205 => [
        "name" => "24 hours", "pricePerPage" => 50, "minPages" => 0, "hrs" => 24, "hrsWriter" => 20, "academicLevel" => LEVEL_PHD,
    ],
    66885 => [
        "name" => "48 hours", "pricePerPage" => 44, "minPages" => 0, "hrs" => 48, "hrsWriter" => 38, "academicLevel" => LEVEL_PHD,
    ],
    66883 => [
        "name" => "3 days", "pricePerPage" => 37, "minPages" => 0, "hrs" => 72, "hrsWriter" => 60, "academicLevel" => LEVEL_PHD,
    ],
    66881 => [
        "name" => "5 days", "pricePerPage" => 35, "minPages" => 0, "hrs" => 120, "hrsWriter" => 72, "academicLevel" => LEVEL_PHD,
    ],
    66879 => [
        "name" => "7 days", "pricePerPage" => 31, "minPages" => 0, "hrs" => 168, "hrsWriter" => 84, "academicLevel" => LEVEL_PHD,
    ],
    66877 => [
        "name" => "14 days", "pricePerPage" => 28, "minPages" => 0, "hrs" => 336, "hrsWriter" => 168, "academicLevel" => LEVEL_PHD,
    ],
    94527 => [
        "name" => "1 month", "pricePerPage" => 25, "minPages" => 30, "hrs" => 720, "hrsWriter" => 450, "academicLevel" => LEVEL_PHD,
    ]
);

$globals["countries"] = array(
    "ad" => [
        "name" => "Andorra", "code" => "020", "phoneCode" => "376", "vat" => 0
    ],
    "ae" => [
        "name" => "United Arab Emirates", "code" => "784", "phoneCode" => "971", "vat" => 0
    ],
    "af" => [
        "name" => "Afghanistan", "code" => "004", "phoneCode" => "93", "vat" => 0
    ],
    "ag" => [
        "name" => "Antigua and Barbuda", "code" => "028", "phoneCode" => "1268", "vat" => 0
    ],
    "ai" => [
        "name" => "Anguilla", "code" => "660", "phoneCode" => "1264", "vat" => 0
    ],
    "al" => [
        "name" => "Albania", "code" => "008", "phoneCode" => "355", "vat" => 0
    ],
    "am" => [
        "name" => "Armenia", "code" => "051", "phoneCode" => "374", "vat" => 0
    ],
    "an" => [
        "name" => "Netherlands Antilles", "code" => "530", "phoneCode" => "599", "vat" => 0
    ],
    "ao" => [
        "name" => "Angola", "code" => "024", "phoneCode" => "244", "vat" => 0
    ],
    "aq" => [
        "name" => "Antarctica", "code" => "010", "phoneCode" => "672", "vat" => 0
    ],
    "ar" => [
        "name" => "Argentina", "code" => "032", "phoneCode" => "54", "vat" => 0
    ],
    "as" => [
        "name" => "American Samoa", "code" => "016", "phoneCode" => "684", "vat" => 0
    ],
    "at" => [
        "name" => "Austria", "code" => "040", "phoneCode" => "43", "vat" => 20
    ],
    "au" => [
        "name" => "Australia", "code" => "036", "phoneCode" => "61", "vat" => 0
    ],
    "aw" => [
        "name" => "Aruba", "code" => "533", "phoneCode" => "297", "vat" => 0
    ],
    "ax" => [
        "name" => "Aland", "code" => "248", "phoneCode" => "222", "vat" => 0
    ],
    "az" => [
        "name" => "Azerbaijan", "code" => "031", "phoneCode" => "994", "vat" => 0
    ],
    "ba" => [
        "name" => "Bosnia and Herzegovina", "code" => "070", "phoneCode" => "387", "vat" => 0
    ],
    "bb" => [
        "name" => "Barbados", "code" => "052", "phoneCode" => "1246", "vat" => 0
    ],
    "bd" => [
        "name" => "Bangladesh", "code" => "050", "phoneCode" => "880", "vat" => 0
    ],
    "be" => [
        "name" => "Belgium", "code" => "056", "phoneCode" => "32", "vat" => 21
    ],
    "bf" => [
        "name" => "Burkina Faso", "code" => "854", "phoneCode" => "226", "vat" => 0
    ],
    "bg" => [
        "name" => "Bulgaria", "code" => "100", "phoneCode" => "359", "vat" => 20
    ],
    "bh" => [
        "name" => "Bahrain", "code" => "048", "phoneCode" => "973", "vat" => 0
    ],
    "bi" => [
        "name" => "Burundi", "code" => "108", "phoneCode" => "257", "vat" => 0
    ],
    "bj" => [
        "name" => "Benin", "code" => "204", "phoneCode" => "229", "vat" => 0
    ],
    "bl" => [
        "name" => "Saint Barthelemy", "code" => "652", "phoneCode" => "590", "vat" => 0
    ],
    "bm" => [
        "name" => "Bermuda", "code" => "060", "phoneCode" => "1441", "vat" => 0
    ],
    "bn" => [
        "name" => "Brunei Darussalam", "code" => "096", "phoneCode" => "673", "vat" => 0
    ],
    "bo" => [
        "name" => "Bolivia", "code" => "068", "phoneCode" => "591", "vat" => 0
    ],
    "br" => [
        "name" => "Brazil", "code" => "076", "phoneCode" => "55", "vat" => 0
    ],
    "bs" => [
        "name" => "Bahamas", "code" => "044", "phoneCode" => "1242", "vat" => 0
    ],
    "bt" => [
        "name" => "Bhutan", "code" => "064", "phoneCode" => "975", "vat" => 0
    ],
    "bv" => [
        "name" => "Bouvet Island", "code" => "074", "phoneCode" => "047", "vat" => 0
    ],
    "bw" => [
        "name" => "Botswana", "code" => "072", "phoneCode" => "267", "vat" => 0
    ],
    "by" => [
        "name" => "Belarus", "code" => "112", "phoneCode" => "375", "vat" => 0
    ],
    "bz" => [
        "name" => "Belize", "code" => "084", "phoneCode" => "501", "vat" => 0
    ],
    "ca" => [
        "name" => "Canada", "code" => "124", "phoneCode" => "1", "vat" => 0
    ],
    "cc" => [
        "name" => "Cocos (Keeling) Islands", "code" => "166", "phoneCode" => "61", "vat" => 0
    ],
    "cd" => [
        "name" => "Congo (Kinshasa)", "code" => "180", "phoneCode" => "243", "vat" => 0
    ],
    "cf" => [
        "name" => "Central African Republic", "code" => "140", "phoneCode" => "236", "vat" => 0
    ],
    "cg" => [
        "name" => "Congo (Brazzaville)", "code" => "178", "phoneCode" => "242", "vat" => 0
    ],
    "ch" => [
        "name" => "Switzerland", "code" => "756", "phoneCode" => "41", "vat" => 0
    ],
    "ci" => [
        "name" => "Cote d'Ivoire (Ivory Coast)", "code" => "384", "phoneCode" => "225", "vat" => 0
    ],
    "ck" => [
        "name" => "Cook Islands", "code" => "184", "phoneCode" => "682", "vat" => 0
    ],
    "cl" => [
        "name" => "Chile", "code" => "152", "phoneCode" => "56", "vat" => 0
    ],
    "cm" => [
        "name" => "Cameroon", "code" => "120", "phoneCode" => "237", "vat" => 0
    ],
    "cn" => [
        "name" => "China", "code" => "156", "phoneCode" => "86", "vat" => 0
    ],
    "co" => [
        "name" => "Colombia", "code" => "170", "phoneCode" => "57", "vat" => 0
    ],
    "cr" => [
        "name" => "Costa Rica", "code" => "188", "phoneCode" => "506", "vat" => 0
    ],
    "cu" => [
        "name" => "Cuba", "code" => "192", "phoneCode" => "53", "vat" => 0
    ],
    "cv" => [
        "name" => "Cape Verde", "code" => "132", "phoneCode" => "238", "vat" => 0
    ],
    "cx" => [
        "name" => "Christmas Island", "code" => "162", "phoneCode" => "61", "vat" => 0
    ],
    "cy" => [
        "name" => "Cyprus", "code" => "196", "phoneCode" => "357", "vat" => 19
    ],
    "cz" => [
        "name" => "Czech Republic", "code" => "203", "phoneCode" => "420", "vat" => 21
    ],
    "de" => [
        "name" => "Germany", "code" => "276", "phoneCode" => "49", "vat" => 19
    ],
    "dj" => [
        "name" => "Djibouti", "code" => "262", "phoneCode" => "253", "vat" => 0
    ],
    "dk" => [
        "name" => "Denmark", "code" => "208", "phoneCode" => "45", "vat" => 25
    ],
    "dm" => [
        "name" => "Dominica", "code" => "212", "phoneCode" => "1767", "vat" => 0
    ],
    "do" => [
        "name" => "Dominican Republic", "code" => "214", "phoneCode" => "809", "vat" => 0
    ],
    "dz" => [
        "name" => "Algeria", "code" => "012", "phoneCode" => "213", "vat" => 0
    ],
    "ec" => [
        "name" => "Ecuador", "code" => "218", "phoneCode" => "593", "vat" => 0
    ],
    "ee" => [
        "name" => "Estonia", "code" => "233", "phoneCode" => "372", "vat" => 20
    ],
    "eg" => [
        "name" => "Egypt", "code" => "818", "phoneCode" => "20", "vat" => 0
    ],
    "eh" => [
        "name" => "Western Sahara", "code" => "732", "phoneCode" => "212", "vat" => 0
    ],
    "er" => [
        "name" => "Eritrea", "code" => "232", "phoneCode" => "291", "vat" => 0
    ],
    "es" => [
        "name" => "Spain", "code" => "724", "phoneCode" => "34", "vat" => 21
    ],
    "et" => [
        "name" => "Ethiopia", "code" => "231", "phoneCode" => "251", "vat" => 0
    ],
    "fi" => [
        "name" => "Finland", "code" => "246", "phoneCode" => "358", "vat" => 24
    ],
    "fj" => [
        "name" => "Fiji", "code" => "242", "phoneCode" => "679", "vat" => 0
    ],
    "fk" => [
        "name" => "Falkland Islands", "code" => "238", "phoneCode" => "500", "vat" => 0
    ],
    "fm" => [
        "name" => "Micronesia", "code" => "583", "phoneCode" => "691", "vat" => 0
    ],
    "fo" => [
        "name" => "Faroe Islands", "code" => "234", "phoneCode" => "298", "vat" => 0
    ],
    "fr" => [
        "name" => "France", "code" => "250", "phoneCode" => "33", "vat" => 20
    ],
    "ga" => [
        "name" => "Gabon", "code" => "266", "phoneCode" => "241", "vat" => 0
    ],
    "gb" => [
        "name" => "United Kingdom", "code" => "826", "phoneCode" => "44", "vat" => 20
    ],
    "gd" => [
            "name" => "Grenada", "code" => "308", "phoneCode" => "1473", "vat" => 0
        ],
    "ge" => [
        "name" => "Georgia", "code" => "268", "phoneCode" => "995", "vat" => 0
    ],
    "gf" => [
        "name" => "French Guiana", "code" => "254", "phoneCode" => "594", "vat" => 0
    ],
    "gg" => [
        "name" => "Guernsey", "code" => "831", "phoneCode" => "441481", "vat" => 0
    ],
    "gh" => [
        "name" => "Ghana", "code" => "288", "phoneCode" => "233", "vat" => 0
    ],
    "gi" => [
        "name" => "Gibraltar", "code" => "292", "phoneCode" => "350", "vat" => 0
    ],
    "gl" => [
        "name" => "Greenland", "code" => "304", "phoneCode" => "299", "vat" => 0
    ],
    "gm" => [
        "name" => "Gambia", "code" => "270", "phoneCode" => "220", "vat" => 0
    ],
    "gn" => [
        "name" => "Guinea", "code" => "324", "phoneCode" => "224", "vat" => 0
    ],
    "gp" => [
        "name" => "Guadeloupe", "code" => "312", "phoneCode" => "590", "vat" => 0
    ],
    "gq" => [
        "name" => "Equatorial Guinea", "code" => "226", "phoneCode" => "240", "vat" => 0
    ],
    "gr" => [
        "name" => "Greece", "code" => "300", "phoneCode" => "30", "vat" => 24
    ],
    "gs" => [
        "name" => "South Georgia and South Sandwich Islands", "code" => "239", "phoneCode" => "500", "vat" => 0
    ],
    "gt" => [
        "name" => "Guatemala", "code" => "320", "phoneCode" => "502", "vat" => 0
    ],
    "gu" => [
        "name" => "Guam", "code" => "316", "phoneCode" => "1671", "vat" => 0
    ],
    "gw" => [
        "name" => "Guinea-Bissau", "code" => "624", "phoneCode" => "245", "vat" => 0
    ],
    "gy" => [
        "name" => "Guyana", "code" => "328", "phoneCode" => "592", "vat" => 0
    ],
    "hk" => [
        "name" => "Hong Kong", "code" => "344", "phoneCode" => "852", "vat" => 0
    ],
    "hm" => [
        "name" => "Heard Island and McDonald Islands", "code" => "334", "phoneCode" => "061", "vat" => 0
    ],
    "hn" => [
        "name" => "Honduras", "code" => "340", "phoneCode" => "504", "vat" => 0
    ],
    "hr" => [
        "name" => "Croatia", "code" => "191", "phoneCode" => "385", "vat" => 25
    ],
    "ht" => [
        "name" => "Haiti", "code" => "332", "phoneCode" => "509", "vat" => 0
    ],
    "hu" => [
        "name" => "Hungary", "code" => "348", "phoneCode" => "36", "vat" => 27
    ],
    "id" => [
        "name" => "Indonesia", "code" => "360", "phoneCode" => "62", "vat" => 0
    ],
    "ie" => [
        "name" => "Ireland", "code" => "372", "phoneCode" => "353", "vat" => 23
    ],
    "il" => [
        "name" => "Israel", "code" => "376", "phoneCode" => "972", "vat" => 0
    ],
    "im" => [
        "name" => "Isle of Man", "code" => "833", "phoneCode" => "441624", "vat" => 0
    ],
    "in" => [
        "name" => "India", "code" => "356", "phoneCode" => "91", "vat" => 0
    ],
    "io" => [
        "name" => "British Indian Ocean Territory", "code" => "086", "phoneCode" => "246", "vat" => 0
    ],
    "iq" => [
        "name" => "Iraq", "code" => "368", "phoneCode" => "964", "vat" => 0
    ],
    "ir" => [
        "name" => "Iran", "code" => "364", "phoneCode" => "98", "vat" => 0
    ],
    "is" => [
        "name" => "Iceland", "code" => "352", "phoneCode" => "354", "vat" => 0
    ],
    "it" => [
        "name" => "Italy", "code" => "380", "phoneCode" => "39", "vat" => 22
    ],
    "je" => [
        "name" => "Jersey", "code" => "832", "phoneCode" => "441534", "vat" => 0
    ],
    "jm" => [
        "name" => "Jamaica", "code" => "388", "phoneCode" => "1876", "vat" => 0
    ],
    "jo" => [
        "name" => "Jordan", "code" => "400", "phoneCode" => "962", "vat" => 0
    ],
    "jp" => [
        "name" => "Japan", "code" => "392", "phoneCode" => "81", "vat" => 0
    ],
    "ke" => [
        "name" => "Kenya", "code" => "404", "phoneCode" => "254", "vat" => 0
    ],
    "kg" => [
        "name" => "Kyrgyzstan", "code" => "417", "phoneCode" => "996", "vat" => 0
    ],
    "kh" => [
        "name" => "Cambodia", "code" => "116", "phoneCode" => "855", "vat" => 0
    ],
    "ki" => [
        "name" => "Kiribati", "code" => "296", "phoneCode" => "686", "vat" => 0
    ],
    "km" => [
        "name" => "Comoros", "code" => "174", "phoneCode" => "269", "vat" => 0
    ],
    "kn" => [
        "name" => "Saint Kitts and Nevis", "code" => "659", "phoneCode" => "1869", "vat" => 0
    ],
    "kp" => [
        "name" => "Korea, North", "code" => "408", "phoneCode" => "850", "vat" => 0
    ],
    "kr" => [
        "name" => "Korea, South", "code" => "410", "phoneCode" => "82", "vat" => 0
    ],
    "kw" => [
        "name" => "Kuwait", "code" => "414", "phoneCode" => "965", "vat" => 0
    ],
    "ky" => [
        "name" => "Cayman Islands", "code" => "136", "phoneCode" => "1345", "vat" => 0
    ],
    "kz" => [
        "name" => "Kazakhstan", "code" => "398", "phoneCode" => "7", "vat" => 0
    ],
    "la" => [
        "name" => "Laos", "code" => "418", "phoneCode" => "856", "vat" => 0
    ],
    "lb" => [
        "name" => "Lebanon", "code" => "422", "phoneCode" => "961", "vat" => 0
    ],
    "lc" => [
        "name" => "Saint Lucia", "code" => "662", "phoneCode" => "1758", "vat" => 0
    ],
    "li" => [
        "name" => "Liechtenstein", "code" => "438", "phoneCode" => "423", "vat" => 0
    ],
    "lk" => [
        "name" => "Sri Lanka", "code" => "144", "phoneCode" => "94", "vat" => 0
    ],
    "lr" => [
        "name" => "Liberia", "code" => "430", "phoneCode" => "231", "vat" => 0
    ],
    "ls" => [
        "name" => "Lesotho", "code" => "426", "phoneCode" => "266", "vat" => 0
    ],
    "lt" => [
        "name" => "Lithuania", "code" => "440", "phoneCode" => "370", "vat" => 21
    ],
    "lu" => [
        "name" => "Luxembourg", "code" => "442", "phoneCode" => "352", "vat" => 17
    ],
    "lv" => [
        "name" => "Latvia", "code" => "428", "phoneCode" => "371", "vat" => 21
    ],
    "ly" => [
        "name" => "Libya", "code" => "434", "phoneCode" => "218", "vat" => 0
    ],
    "ma" => [
        "name" => "Morocco", "code" => "504", "phoneCode" => "212", "vat" => 0
    ],
    "mc" => [
        "name" => "Monaco", "code" => "492", "phoneCode" => "377", "vat" => 0
    ],
    "md" => [
        "name" => "Moldova", "code" => "498", "phoneCode" => "373", "vat" => 0
    ],
    "me" => [
        "name" => "Montenegro", "code" => "499", "phoneCode" => "382", "vat" => 0
    ],
    "mf" => [
        "name" => "Saint Martin (French part)", "code" => "663", "phoneCode" => "590", "vat" => 0
    ],
    "mg" => [
        "name" => "Madagascar", "code" => "450", "phoneCode" => "261", "vat" => 0
    ],
    "mh" => [
        "name" => "Marshall Islands", "code" => "584", "phoneCode" => "692", "vat" => 0
    ],
    "mk" => [
        "name" => "Macedonia", "code" => "807", "phoneCode" => "389", "vat" => 0
    ],
    "ml" => [
        "name" => "Mali", "code" => "466", "phoneCode" => "223", "vat" => 0
    ],
    "mm" => [
        "name" => "Myanmar", "code" => "104", "phoneCode" => "95", "vat" => 0
    ],
    "mn" => [
        "name" => "Mongolia", "code" => "496", "phoneCode" => "976", "vat" => 0
    ],
    "mo" => [
        "name" => "Macau", "code" => "446", "phoneCode" => "853", "vat" => 0
    ],
    "mp" => [
        "name" => "Northern Mariana Islands", "code" => "580", "phoneCode" => "670", "vat" => 0
    ],
    "mq" => [
        "name" => "Martinique", "code" => "474", "phoneCode" => "596", "vat" => 0
    ],
    "mr" => [
        "name" => "Mauritania", "code" => "478", "phoneCode" => "222", "vat" => 0
    ],
    "ms" => [
        "name" => "Montserrat", "code" => "500", "phoneCode" => "1664", "vat" => 0
    ],
    "mt" => [
        "name" => "Malta", "code" => "470", "phoneCode" => "356", "vat" => 18
    ],
    "mu" => [
        "name" => "Mauritius", "code" => "480", "phoneCode" => "230", "vat" => 0
    ],
    "mv" => [
        "name" => "Maldives", "code" => "462", "phoneCode" => "960", "vat" => 0
    ],
    "mw" => [
        "name" => "Malawi", "code" => "454", "phoneCode" => "265", "vat" => 0
    ],
    "mx" => [
        "name" => "Mexico", "code" => "484", "phoneCode" => "52", "vat" => 0
    ],
    "my" => [
        "name" => "Malaysia", "code" => "458", "phoneCode" => "60", "vat" => 0
    ],
    "mz" => [
        "name" => "Mozambique", "code" => "508", "phoneCode" => "258", "vat" => 0
    ],
    "na" => [
        "name" => "Namibia", "code" => "516", "phoneCode" => "264", "vat" => 0
    ],
    "nc" => [
        "name" => "New Caledonia", "code" => "540", "phoneCode" => "687", "vat" => 0
    ],
    "ne" => [
        "name" => "Niger", "code" => "562", "phoneCode" => "227", "vat" => 0
    ],
    "nf" => [
        "name" => "Norfolk Island", "code" => "574", "phoneCode" => "672", "vat" => 0
    ],
    "ng" => [
        "name" => "Nigeria", "code" => "566", "phoneCode" => "234", "vat" => 0
    ],
    "ni" => [
        "name" => "Nicaragua", "code" => "558", "phoneCode" => "505", "vat" => 0
    ],
    "nl" => [
        "name" => "Netherlands", "code" => "528", "phoneCode" => "31", "vat" => 21
    ],
    "no" => [
        "name" => "Norway", "code" => "578", "phoneCode" => "47", "vat" => 0
    ],
    "np" => [
        "name" => "Nepal", "code" => "524", "phoneCode" => "977", "vat" => 0
    ],
    "nr" => [
        "name" => "Nauru", "code" => "520", "phoneCode" => "674", "vat" => 0
    ],
    "nu" => [
        "name" => "Niue", "code" => "570", "phoneCode" => "683", "vat" => 0
    ],
    "nz" => [
        "name" => "New Zealand", "code" => "554", "phoneCode" => "64", "vat" => 0
    ],
    "om" => [
        "name" => "Oman", "code" => "512", "phoneCode" => "968", "vat" => 0
    ],
    "pa" => [
        "name" => "Panama", "code" => "591", "phoneCode" => "507", "vat" => 0
    ],
    "pe" => [
        "name" => "Peru", "code" => "604", "phoneCode" => "51", "vat" => 0
    ],
    "pf" => [
        "name" => "Polynesia (French)", "code" => "258", "phoneCode" => "689", "vat" => 0
    ],
    "pg" => [
        "name" => "Papua New Guinea", "code" => "598", "phoneCode" => "675", "vat" => 0
    ],
    "ph" => [
        "name" => "Philippines", "code" => "608", "phoneCode" => "63", "vat" => 0
    ],
    "pk" => [
        "name" => "Pakistan", "code" => "586", "phoneCode" => "92", "vat" => 0
    ],
    "pl" => [
        "name" => "Poland", "code" => "616", "phoneCode" => "48", "vat" => 23
    ],
    "pm" => [
        "name" => "Saint Pierre and Miquelon", "code" => "666", "phoneCode" => "508", "vat" => 0
    ],
    "pn" => [
        "name" => "Pitcairn Island", "code" => "612", "phoneCode" => "872", "vat" => 0
    ],
    "pr" => [
        "name" => "Puerto Rico", "code" => "630", "phoneCode" => "1787", "vat" => 0
    ],
    "ps" => [
        "name" => "Palestine", "code" => "275", "phoneCode" => "970", "vat" => 0
    ],
    "pt" => [
        "name" => "Portugal", "code" => "620", "phoneCode" => "351", "vat" => 23
    ],
    "pw" => [
        "name" => "Palau", "code" => "585", "phoneCode" => "680", "vat" => 0
    ],
    "py" => [
        "name" => "Paraguay", "code" => "600", "phoneCode" => "595", "vat" => 0
    ],
    "qa" => [
        "name" => "Qatar", "code" => "634", "phoneCode" => "974", "vat" => 0
    ],
    "re" => [
        "name" => "Reunion", "code" => "638", "phoneCode" => "262", "vat" => 0
    ],
    "ro" => [
        "name" => "Romania", "code" => "642", "phoneCode" => "40", "vat" => 19
    ],
    "rs" => [
        "name" => "Serbia", "code" => "688", "phoneCode" => "381", "vat" => 0
    ],
    "ru" => [
        "name" => "Russian Federation", "code" => "643", "phoneCode" => "7", "vat" => 0
    ],
    "rw" => [
        "name" => "Rwanda", "code" => "646", "phoneCode" => "250", "vat" => 0
    ],
    "sa" => [
        "name" => "Saudi Arabia", "code" => "682", "phoneCode" => "966", "vat" => 0
    ],
    "sb" => [
        "name" => "Solomon Islands", "code" => "090", "phoneCode" => "677", "vat" => 0
    ],
    "sc" => [
        "name" => "Seychelles", "code" => "690", "phoneCode" => "248", "vat" => 0
    ],
    "sd" => [
        "name" => "Sudan", "code" => "736", "phoneCode" => "249", "vat" => 0
    ],
    "se" => [
        "name" => "Sweden", "code" => "752", "phoneCode" => "46", "vat" => 25
    ],
    "sg" => [
        "name" => "Singapore", "code" => "702", "phoneCode" => "65", "vat" => 0
    ],
    "sh" => [
        "name" => "Saint Helena", "code" => "654", "phoneCode" => "290", "vat" => 0
    ],
    "si" => [
        "name" => "Slovenia", "code" => "705", "phoneCode" => "386", "vat" => 22
    ],
    "sj" => [
        "name" => "Svalbard and Jan Mayen Islands", "code" => "744", "phoneCode" => "047", "vat" => 0
    ],
    "sk" => [
        "name" => "Slovakia", "code" => "703", "phoneCode" => "421", "vat" => 20
    ],
    "sl" => [
        "name" => "Sierra Leone", "code" => "694", "phoneCode" => "232", "vat" => 0
    ],
    "sm" => [
        "name" => "San Marino", "code" => "674", "phoneCode" => "378", "vat" => 0
    ],
    "sn" => [
        "name" => "Senegal", "code" => "686", "phoneCode" => "221", "vat" => 0
    ],
    "so" => [
        "name" => "Somalia", "code" => "706", "phoneCode" => "252", "vat" => 0
    ],
    "sr" => [
        "name" => "Suriname", "code" => "740", "phoneCode" => "597", "vat" => 0
    ],
    "st" => [
        "name" => "Sao Tome and Principe", "code" => "678", "phoneCode" => "239", "vat" => 0
    ],
    "sv" => [
        "name" => "El Salvador", "code" => "222", "phoneCode" => "503", "vat" => 0
    ],
    "sy" => [
        "name" => "Syria", "code" => "760", "phoneCode" => "963", "vat" => 0
    ],
    "sz" => [
        "name" => "Swaziland", "code" => "748", "phoneCode" => "268", "vat" => 0
    ],
    "tc" => [
        "name" => "Turks and Caicos Islands", "code" => "796", "phoneCode" => "1649", "vat" => 0
    ],
    "td" => [
        "name" => "Chad", "code" => "148", "phoneCode" => "235", "vat" => 0
    ],
    "tf" => [
        "name" => "French Southern Lands", "code" => "260", "phoneCode" => "262", "vat" => 0
    ],
    "tg" => [
        "name" => "Togo", "code" => "768", "phoneCode" => "228", "vat" => 0
    ],
    "th" => [
        "name" => "Thailand", "code" => "764", "phoneCode" => "66", "vat" => 0
    ],
    "tj" => [
        "name" => "Tajikistan", "code" => "762", "phoneCode" => "992", "vat" => 0
    ],
    "tk" => [
        "name" => "Tokelau", "code" => "772", "phoneCode" => "690", "vat" => 0
    ],
    "tl" => [
        "name" => "Timor-Leste", "code" => "626", "phoneCode" => "670", "vat" => 0
    ],
    "tm" => [
        "name" => "Turkmenistan", "code" => "795", "phoneCode" => "993", "vat" => 0
    ],
    "tn" => [
        "name" => "Tunisia", "code" => "788", "phoneCode" => "216", "vat" => 0
    ],
    "to" => [
        "name" => "Tonga", "code" => "776", "phoneCode" => "676", "vat" => 0
    ],
    "tr" => [
        "name" => "Turkey", "code" => "792", "phoneCode" => "90", "vat" => 0
    ],
    "tt" => [
        "name" => "Trinidad and Tobago", "code" => "780", "phoneCode" => "1868", "vat" => 0
    ],
    "tv" => [
        "name" => "Tuvalu", "code" => "798", "phoneCode" => "688", "vat" => 0
    ],
    "tw" => [
        "name" => "Taiwan", "code" => "158", "phoneCode" => "886", "vat" => 0
    ],
    "tz" => [
        "name" => "Tanzania", "code" => "834", "phoneCode" => "255", "vat" => 0
    ],
    "ua" => [
        "name" => "Ukraine", "code" => "804", "phoneCode" => "380", "vat" => 0
    ],
    "ug" => [
        "name" => "Uganda", "code" => "800", "phoneCode" => "256", "vat" => 0
    ],
    "um" => [
        "name" => "United States Minor Outlying Islands", "code" => "581", "phoneCode" => "1", "vat" => 0
    ],
    "us" => [
        "name" => "United States of America", "code" => "840", "phoneCode" => "1", "vat" => 0
    ],
    "uy" => [
        "name" => "Uruguay", "code" => "858", "phoneCode" => "598", "vat" => 0
    ],
    "uz" => [
        "name" => "Uzbekistan", "code" => "860", "phoneCode" => "998", "vat" => 0
    ],
    "va" => [
        "name" => "Vatican", "code" => "336", "phoneCode" => "39", "vat" => 0
    ],
    "vc" => [
        "name" => "Saint Vincent and the Grenadines", "code" => "670", "phoneCode" => "1784", "vat" => 0
    ],
    "ve" => [
        "name" => "Venezuela", "code" => "862", "phoneCode" => "58", "vat" => 0
    ],
    "vg" => [
        "name" => "Virgin Islands, British", "code" => "092", "phoneCode" => "1284", "vat" => 0
    ],
    "vi" => [
        "name" => "Virgin Islands, U.S.", "code" => "850", "phoneCode" => "1340", "vat" => 0
    ],
    "vn" => [
        "name" => "Vietnam", "code" => "704", "phoneCode" => "84", "vat" => 0
    ],
    "vu" => [
        "name" => "Vanuatu", "code" => "548", "phoneCode" => "678", "vat" => 0
    ],
    "wf" => [
        "name" => "Wallis and Futuna Islands", "code" => "876", "phoneCode" => "681", "vat" => 0
    ],
    "ws" => [
        "name" => "Samoa", "code" => "882", "phoneCode" => "684", "vat" => 0
    ],
    "ye" => [
        "name" => "Yemen", "code" => "887", "phoneCode" => "967", "vat" => 0
    ],
    "yt" => [
        "name" => "Mayotte", "code" => "175", "phoneCode" => "269", "vat" => 0
    ],
    "za" => [
        "name" => "South Africa", "code" => "710", "phoneCode" => "27", "vat" => 0
    ],
    "zm" => [
        "name" => "Zambia", "code" => "894", "phoneCode" => "260", "vat" => 0
    ],
    "zw" => [
        "name" => "Zimbabwe", "code" => "716", "phoneCode" => "263", "vat" => 0
    ]
);

//**********************
//Allowed extensions (lowercase insert)
//**********************
$ext_img = array('jpg', 'jpeg', 'png', 'gif', 'bmp', 'tiff', 'svg'); //Images
$ext_file = array('doc', 'docx','rtf', 'pdf', 'xls', 'xlsx', 'txt', 'csv','html','xhtml','psd','sql','log','fla','xml','ade','adp','mdb','accdb','ppt','pptx','odt','ots','ott','odb','odg','otp','otg','odf','ods','odp','css','ai', 'json'); //Files
$ext_video = array('mov', 'mpeg', 'mp4', 'avi', 'mpg', 'wma', 'flv', 'webm'); //Video
$ext_music = array('mp3', 'm4a', 'ac3', 'aiff', 'mid','ogg','wav'); //Audio
$ext_misc = array('zip', 'rar','gz','tar','iso','dmg'); //Archives

$globals['extensions'] = array_merge($ext_img, $ext_file, $ext_misc, $ext_video, $ext_music); //allowed extensions

//**********************
//Allowed mime types
//**********************
$mime_img = array('image/jpeg', 'image/png', 'image/gif', 'image/bmp', 'image/tiff', 'image/svg');
$mime_file = array('application/pdf');
$mime_video = array('video/mpeg', 'video/mp4', 'video/x-msvideo', 'audio/x-ms-wma', 'video/x-flv', 'video/webm');

$globals['mime'] = array_merge($mime_img, $mime_file, $mime_video);