<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 * 
 ____  ____   __  _  _  __  _  _ 
(  _ \(  _ \ /  \( \/ )(  )( \/ )
 ) __/ )   /(  O ))  (  )( / \/ \
(__)  (__\_) \__/(_/\_)(__)\_)(_/
*/

define('PROX_DS', DIRECTORY_SEPARATOR);
define('PROX_NAMESPACE',          'Proxim');
define('PROX_DIR',                   dirname(__FILE__) . PROX_DS);
define('PROX_DIR_ROOT',              dirname(__DIR__) . PROX_DS);

define('PROX_DIR_INCLUDES',           PROX_DIR_ROOT . 'prox-includes' . PROX_DS);
define('PROX_DIR_CLASSES',            PROX_DIR_INCLUDES . 'classes' . PROX_DS);
define('PROX_DIR_CONTROLLERS',        PROX_DIR_INCLUDES . 'controllers' . PROX_DS);
define('PROX_DIR_CONTENT',            PROX_DIR_ROOT . 'content' . PROX_DS);
define('PROX_DIR_MODULE',              PROX_DIR_CONTENT . 'modules' . PROX_DS);

define('PROX_DIR_CACHE',              PROX_DIR . 'cache' . PROX_DS);
define('PROX_DIR_THEMES',             PROX_DIR . 'templates' . PROX_DS);

require_once PROX_DIR_ROOT . 'config.php'; 
require_once PROX_DIR_ROOT . 'autoload.php';
require_once PROX_DIR . 'vendor' . PROX_DS . 'autoload.php';
require_once PROX_DIR . 'functions.php';

if (!defined('PROX_MAGIC_QUOTES_GPC')) {
    define('PROX_MAGIC_QUOTES_GPC', false);
}

define('PROX_UPDATES_URL', 'https://proxim.craftyworks.co/releases/admin');

use Monolog\Handler\StreamHandler;
use Proxim\Cache\CacheApcCore;
use Proxim\Cache\CacheMemcachedCore;
use Proxim\Configuration;
use Proxim\Database\DbCore;
use Proxim\Database\DbMySQLiCore;
use Proxim\Database\DbPDOCore;
use Proxim\Util\DateUtils;

abstract class Db extends DbCore {};
class DbPDO extends DbPDOCore {};
class DbMySQLi extends DbMySQLiCore {};
class CacheMemcached extends CacheMemcachedCore {};
class CacheApc extends CacheApcCore {};
use \VisualAppeal\AutoUpdate;

$smarty = new Smarty();
$smarty->setCompileDir( PROX_DIR_CACHE . 'compile');
$smarty->setCacheDir( PROX_DIR_CACHE );
$smarty->use_sub_dirs = true;
$smarty->caching = false;
$smarty->setTemplateDir( PROX_DIR_THEMES );
$smarty->escape_html = true;

// delete old updater
if(is_dir(PROX_DIR_ROOT . 'updater')) {
    deleteDir(PROX_DIR_ROOT . 'updater');
}

$update = new AutoUpdate(
    PROX_DIR_ROOT . 'upgrader' . PROX_DS . 'temp', 
    PROX_DIR_ROOT,
    100
);

// Custom logger (optional)
$logger = new \Monolog\Logger("default");
$logger->pushHandler(new Monolog\Handler\StreamHandler(__DIR__ . '/update.log'));
$update->setLogger($logger);

// Cache (optional but recommended)
$cache = new Desarrolla2\Cache\File(__DIR__ . '/cache');
$update->setCache($cache, 3600);

$update->setCurrentVersion( '1.0.0' );
$update->setUpdateUrl( PROX_UPDATES_URL );

if ($update->checkUpdate() === false) {
    $smarty->assign([
        'title' => "Update unsuccessful",
        'update_message' => 'Sorry, there was a problem updating Proxim. No changes were made.'
    ]);
    $smarty->display('error.tpl');
    exit;
}

if ($update->newVersionAvailable()) {
    $result = $update->update(false);
    if ($result === true) {
        Configuration::updateValue('PROX_NEW_VERSION', false);

        $new_version = $update->getLatestVersion();

        Configuration::updateValue('PROX_VERSION', $new_version);
        Configuration::updateValue('PROX_LAST_UPDATE', DateUtils::now());

        if(file_exists(PROX_DIR . 'install' . PROX_DS . 'install-' . $new_version . '.php')) {
            include PROX_DIR . 'install' . PROX_DS . 'install-' . $new_version . '.php';
        }

        $smarty->assign([
            'title' => "Notify Update",
            'system_version' => $new_version
        ]);
        $smarty->display('success.tpl'); 
        exit;
    } else {
        $smarty->assign([
            'title' => "Update unsuccessful",
            'update_message' => 'Sorry, there was a problem updating Proxim. No changes were made.'
        ]);
        $smarty->display('error.tpl'); 
        exit;
    }
} else {
    $smarty->assign([
        'title' => "Notify Update",
        'update_message' => sprintf('You have the latest version of Proxim: %s. No changes were made.', Configuration::get('PROX_VERSION'))
    ]);
    $smarty->display('error.tpl'); 
    exit;
}