<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

$db_structure = "
    CREATE TABLE IF NOT EXISTS `prox_payment` ( 
        `payment_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        `node_id` BIGINT(20) UNSIGNED NOT NULL,
        `node_type` VARCHAR(20) DEFAULT NULL,
        `currency_id` BIGINT(20) UNSIGNED DEFAULT NULL,
        `conversion_rate` FLOAT(14,2) NOT NULL DEFAULT 0.00,
        `payment_method` VARCHAR(255) DEFAULT NULL,
        `transaction_id` VARCHAR(255) DEFAULT NULL,
        `amount` FLOAT(14,2) NOT NULL DEFAULT 0.00,
        `date_add` DATETIME DEFAULT NULL,
    PRIMARY KEY(`payment_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

    ALTER TABLE `prox_employee` ADD (
        `number_of_takes` INT(10) UNSIGNED DEFAULT '0'
    );
";

Db::getInstance()->Execute($db_structure);