<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */


try {
    Db::getInstance()->Execute("
        CREATE TABLE IF NOT EXISTS `prox_user_session` (
            `session_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            `session_token` VARCHAR(64) NOT NULL,
            `user_id` BIGINT(20) UNSIGNED NOT NULL,
            `user_browser` VARCHAR(64) NOT NULL,
            `user_os` VARCHAR(64) NOT NULL,
            `user_ip` VARCHAR(64) NOT NULL,
            `date_add` DATETIME DEFAULT NULL,
            UNIQUE KEY `session_token` (`session_token`),
            KEY `user_ip` (`user_ip`),
        PRIMARY KEY(`session_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
    ");
} catch (\Exception $e) {

}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_order` ADD (
            `ordermanager_id` BIGINT(20) UNSIGNED DEFAULT NULL,
            `ordermanager_assigned` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
            `ordermanager_assigned_at` DATETIME DEFAULT NULL,
            `ordermanager_pay` FLOAT(14,2) DEFAULT 0.00,
            `is_ordermanager_paid` TINYINT(1) UNSIGNED DEFAULT '0',
            `ordermanager_paid_at` DATETIME DEFAULT NULL
        );
    ");
} catch (\Exception $e) {

}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_order` ADD (
            `excel_sheets` INT(10) UNSIGNED NOT NULL DEFAULT '0'
        );
    ");
} catch (\Exception $e) {

}

try {
    Db::getInstance()->Execute("
        ALTER TABLE `prox_order` ADD (
            `order_type` ENUM('academic', 'article') NOT NULL default 'academic'
        );
    ");
} catch (\Exception $e) {

}